/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.similarity;

import java.util.Collection;
import java.util.Set;
import org.coode.oppl.similarity.SimilarityMeasure;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.utils.OWLObjectExtractor;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class SymbolBasedSimilarity
implements SimilarityMeasure<OWLObject> {
    @Override
    public double compare(OWLObject anObject, OWLObject anotherObject) {
        Set<OWLObject> anObjectOWLPrimitives = this.extractSymbols(ArgCheck.checkNotNull(anObject, "anObject"));
        Set<OWLObject> anotherObjectOWLPrimitives = this.extractSymbols(ArgCheck.checkNotNull(anotherObject, "anotherObject"));
        return this.compareSymbols(anObjectOWLPrimitives, anotherObjectOWLPrimitives);
    }

    protected double compareSymbols(Collection<? extends OWLObject> anObjectSymbols, Collection<? extends OWLObject> anotherObjectSymbols) {
        double toReturn;
        ArgCheck.checkNotNull(anObjectSymbols, "anObjectSymbols");
        ArgCheck.checkNotNull(anotherObjectSymbols, "anotherObjectSymbols");
        double d = toReturn = anObjectSymbols.isEmpty() && anotherObjectSymbols.isEmpty() ? 0.0 : 1.0;
        if (toReturn > 0.0) {
            long intersection = anObjectSymbols.stream().filter(anotherObjectSymbols::contains).count();
            long union = (long)(anObjectSymbols.size() + anotherObjectSymbols.size()) - intersection;
            toReturn = (double)intersection / (double)union;
        }
        return toReturn;
    }

    protected Set<OWLObject> extractSymbols(OWLObject anObject) {
        return OWLAPIStreamUtils.asSet(OWLObjectExtractor.getAllOWLPrimitives(ArgCheck.checkNotNull(anObject, "anObject")));
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }
}

