/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.similarity;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.coode.oppl.similarity.HashFunction;
import org.coode.oppl.similarity.OWLConstruct;
import org.coode.oppl.utils.OWLVocabulary;
import org.coode.oppl.utils.PrimeNumbersUtils;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyCharacteristicAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasValueRestriction;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNaryBooleanClassExpression;
import org.semanticweb.owlapi.model.OWLNaryClassAxiom;
import org.semanticweb.owlapi.model.OWLNaryIndividualAxiom;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyCharacteristicAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.OWLPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLQuantifiedRestriction;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

public class StructuralHashFunction
implements HashFunction,
OWLObjectVisitorEx<Integer> {
    private static final Map<AxiomType<?>, Integer> axiomTypeHashCodes = new HashMap();
    private static final Map<IRI, Integer> iriHashCodes = new HashMap<IRI, Integer>();
    private static final Map<OWLEntity, Integer> entityHashCodes = new HashMap<OWLEntity, Integer>();
    private static final EnumMap<OWLConstruct, Integer> constructHashCodes = new EnumMap(OWLConstruct.class);
    private static final Map<Integer, Integer> integerHashCodes = new HashMap<Integer, Integer>();
    private static int maxPrime = 1;
    private static final Integer ONE = 1;

    public <T> Integer doDefault(T object) {
        return ONE;
    }

    public Integer visit(OWLSubClassOfAxiom axiom) {
        return this.getAxiomTypeHashValue(axiom.getAxiomType()) * (Integer)axiom.getSubClass().accept((OWLObjectVisitorEx)this) * (Integer)axiom.getSuperClass().accept((OWLObjectVisitorEx)this);
    }

    private Integer getAxiomTypeHashValue(AxiomType<?> axiomType) {
        return axiomTypeHashCodes.computeIfAbsent(axiomType, x -> this.createHashCode((AxiomType<?>)x));
    }

    protected int createHashCode(AxiomType<?> axiomType) {
        return this.createHashCode(axiomType, axiomTypeHashCodes);
    }

    public Integer visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        return this.getPropertyAssertionHashCode((OWLPropertyAssertionAxiom<?, ?>)axiom);
    }

    public Integer visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        return this.getOWLObjectPropertyCharacteristicAxiomHashCode((OWLObjectPropertyCharacteristicAxiom)axiom);
    }

    private int getOWLObjectPropertyCharacteristicAxiomHashCode(OWLObjectPropertyCharacteristicAxiom axiom) {
        return this.getAxiomTypeHashValue(axiom.getAxiomType()) * (Integer)((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitorEx)this);
    }

    public Integer visit(OWLReflexiveObjectPropertyAxiom axiom) {
        return this.getOWLObjectPropertyCharacteristicAxiomHashCode((OWLObjectPropertyCharacteristicAxiom)axiom);
    }

    public Integer visit(OWLDisjointClassesAxiom axiom) {
        return this.getNaryClassAxiomHashCode((OWLNaryClassAxiom)axiom);
    }

    private int getNaryClassAxiomHashCode(OWLNaryClassAxiom axiom) {
        return this.getAxiomTypeHashValue(axiom.getAxiomType()) * this.getCollectionHashCode(axiom.classExpressions());
    }

    private int getCollectionHashCode(Collection<? extends OWLObject> collection) {
        int toReturn = 1;
        for (OWLObject oWLObject : collection) {
            toReturn *= ((Integer)oWLObject.accept((OWLObjectVisitorEx)this)).intValue();
        }
        return toReturn;
    }

    private int getCollectionHashCode(Stream<? extends OWLObject> collection) {
        AtomicInteger toReturn = new AtomicInteger(1);
        collection.forEach(o -> toReturn.set(toReturn.get() * (Integer)o.accept((OWLObjectVisitorEx)this)));
        return toReturn.get();
    }

    public Integer visit(OWLDataPropertyDomainAxiom axiom) {
        return this.getOWLPropertyDomainAxiomHashCode((OWLPropertyDomainAxiom<?>)axiom);
    }

    private int getOWLPropertyDomainAxiomHashCode(OWLPropertyDomainAxiom<?> axiom) {
        return this.getAxiomTypeHashValue(axiom.getAxiomType()) * (Integer)((OWLPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitorEx)this) * (Integer)((OWLClassExpression)axiom.getDomain()).accept((OWLObjectVisitorEx)this);
    }

    private Integer getIRIHashCode(IRI uri) {
        Integer toReturn = iriHashCodes.get(uri);
        if (toReturn == null) {
            toReturn = this.createHashCode(uri);
        }
        return toReturn;
    }

    protected int createHashCode(IRI uri) {
        return this.createHashCode(uri, iriHashCodes);
    }

    public Integer visit(OWLObjectPropertyDomainAxiom axiom) {
        return this.getOWLPropertyDomainAxiomHashCode((OWLPropertyDomainAxiom<?>)axiom);
    }

    public Integer visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        return this.getNaryPropertyAxiomHashCode((OWLNaryPropertyAxiom<?>)axiom);
    }

    private int getNaryPropertyAxiomHashCode(OWLNaryPropertyAxiom<?> axiom) {
        return this.getAxiomTypeHashValue(axiom.getAxiomType()) * this.getCollectionHashCode(axiom.properties());
    }

    public Integer visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        return this.getPropertyAssertionHashCode((OWLPropertyAssertionAxiom<?, ?>)axiom);
    }

    private int getPropertyAssertionHashCode(OWLPropertyAssertionAxiom<?, ?> axiom) {
        return this.getAxiomTypeHashValue(axiom.getAxiomType()) * (Integer)axiom.getProperty().accept((OWLObjectVisitorEx)this) * (Integer)axiom.getSubject().accept((OWLObjectVisitorEx)this) * (Integer)axiom.getObject().accept((OWLObjectVisitorEx)this);
    }

    public Integer visit(OWLDifferentIndividualsAxiom axiom) {
        return this.getNaryIndividualAxiomHashCode((OWLNaryIndividualAxiom)axiom);
    }

    private int getNaryIndividualAxiomHashCode(OWLNaryIndividualAxiom axiom) {
        return this.getAxiomTypeHashValue(axiom.getAxiomType()) * this.getCollectionHashCode(axiom.individuals());
    }

    public Integer visit(OWLDisjointDataPropertiesAxiom axiom) {
        return this.getNaryPropertyAxiomHashCode((OWLNaryPropertyAxiom<?>)axiom);
    }

    public Integer visit(OWLDisjointObjectPropertiesAxiom axiom) {
        return this.getNaryPropertyAxiomHashCode((OWLNaryPropertyAxiom<?>)axiom);
    }

    public Integer visit(OWLObjectPropertyRangeAxiom axiom) {
        return this.getOWLPropertyRangeAxiomHashCode((OWLPropertyRangeAxiom<?, ?>)axiom);
    }

    private int getOWLPropertyRangeAxiomHashCode(OWLPropertyRangeAxiom<?, ?> axiom) {
        return this.getAxiomTypeHashValue(axiom.getAxiomType()) * (Integer)((OWLPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitorEx)this) * (Integer)((OWLPropertyRange)axiom.getRange()).accept((OWLObjectVisitorEx)this);
    }

    public Integer visit(OWLObjectPropertyAssertionAxiom axiom) {
        return this.getPropertyAssertionHashCode((OWLPropertyAssertionAxiom<?, ?>)axiom);
    }

    public Integer visit(OWLFunctionalObjectPropertyAxiom axiom) {
        return this.getOWLObjectPropertyCharacteristicAxiomHashCode((OWLObjectPropertyCharacteristicAxiom)axiom);
    }

    public Integer visit(OWLSubObjectPropertyOfAxiom axiom) {
        return this.getOWLSubPropertyAxiomHashCode((OWLSubPropertyAxiom<?>)axiom);
    }

    private int getOWLSubPropertyAxiomHashCode(OWLSubPropertyAxiom<?> axiom) {
        return this.getAxiomTypeHashValue(axiom.getAxiomType()) * (Integer)axiom.getSubProperty().accept((OWLObjectVisitorEx)this) * (Integer)axiom.getSuperProperty().accept((OWLObjectVisitorEx)this);
    }

    public Integer visit(OWLDisjointUnionAxiom axiom) {
        return this.getAxiomTypeHashValue(axiom.getAxiomType()) * this.getCollectionHashCode(axiom.classExpressions());
    }

    public Integer visit(OWLDeclarationAxiom axiom) {
        return this.getAxiomTypeHashValue(axiom.getAxiomType()) * (Integer)axiom.getEntity().accept((OWLObjectVisitorEx)this);
    }

    public Integer visit(OWLSymmetricObjectPropertyAxiom axiom) {
        return this.getOWLObjectPropertyCharacteristicAxiomHashCode((OWLObjectPropertyCharacteristicAxiom)axiom);
    }

    public Integer visit(OWLDataPropertyRangeAxiom axiom) {
        return this.getOWLPropertyRangeAxiomHashCode((OWLPropertyRangeAxiom<?, ?>)axiom);
    }

    public Integer visit(OWLFunctionalDataPropertyAxiom axiom) {
        return this.getOWLDataPropertyCharacteristicAxiomHashCode((OWLDataPropertyCharacteristicAxiom)axiom);
    }

    private int getOWLDataPropertyCharacteristicAxiomHashCode(OWLDataPropertyCharacteristicAxiom axiom) {
        return this.getAxiomTypeHashValue(axiom.getAxiomType()) * (Integer)((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitorEx)this);
    }

    public Integer visit(OWLEquivalentDataPropertiesAxiom axiom) {
        return this.getNaryPropertyAxiomHashCode((OWLNaryPropertyAxiom<?>)axiom);
    }

    public Integer visit(OWLClassAssertionAxiom axiom) {
        return this.getAxiomTypeHashValue(axiom.getAxiomType()) * (Integer)axiom.getClassExpression().accept((OWLObjectVisitorEx)this) * (Integer)axiom.getIndividual().accept((OWLObjectVisitorEx)this);
    }

    public Integer visit(OWLEquivalentClassesAxiom axiom) {
        return this.getNaryClassAxiomHashCode((OWLNaryClassAxiom)axiom);
    }

    public Integer visit(OWLDataPropertyAssertionAxiom axiom) {
        return this.getPropertyAssertionHashCode((OWLPropertyAssertionAxiom<?, ?>)axiom);
    }

    public Integer visit(OWLTransitiveObjectPropertyAxiom axiom) {
        return this.getOWLObjectPropertyCharacteristicAxiomHashCode((OWLObjectPropertyCharacteristicAxiom)axiom);
    }

    public Integer visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        return this.getOWLObjectPropertyCharacteristicAxiomHashCode((OWLObjectPropertyCharacteristicAxiom)axiom);
    }

    public Integer visit(OWLSubDataPropertyOfAxiom axiom) {
        return this.getOWLSubPropertyAxiomHashCode((OWLSubPropertyAxiom<?>)axiom);
    }

    public Integer visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        return this.getOWLObjectPropertyCharacteristicAxiomHashCode((OWLObjectPropertyCharacteristicAxiom)axiom);
    }

    public Integer visit(OWLSameIndividualAxiom axiom) {
        return this.getNaryIndividualAxiomHashCode((OWLNaryIndividualAxiom)axiom);
    }

    public Integer visit(OWLSubPropertyChainOfAxiom axiom) {
        return this.getAxiomTypeHashValue(axiom.getAxiomType()) * (Integer)axiom.getSuperProperty().accept((OWLObjectVisitorEx)this) * this.getOWLConstructHashCode(OWLConstruct.PROPERTY_CHAIN) * this.getCollectionHashCode(axiom.getPropertyChain());
    }

    public Integer visit(OWLInverseObjectPropertiesAxiom axiom) {
        return this.getNaryPropertyAxiomHashCode((OWLNaryPropertyAxiom<?>)axiom);
    }

    public Integer visit(SWRLRule axiom) {
        return this.getAxiomTypeHashValue(axiom.getAxiomType()) * axiom.bodyList().hashCode() * axiom.headList().hashCode();
    }

    public Integer visit(OWLClass owlClass) {
        return this.getOWLEntityHashCode((OWLEntity)owlClass);
    }

    public Integer visit(IRI iri) {
        return this.getIRIHashCode(iri);
    }

    private int getOWLEntityHashCode(OWLEntity owlEntity) {
        OWLEntity representative = (OWLEntity)owlEntity.accept((OWLEntityVisitorEx)new OWLEntityVisitorEx<OWLEntity>(){

            public OWLEntity visit(OWLClass cls) {
                return OWLVocabulary.getOWLThing();
            }

            public OWLEntity visit(OWLObjectProperty property) {
                return OWLVocabulary.getOWLTopObjectProperty();
            }

            public OWLEntity visit(OWLDataProperty property) {
                return OWLVocabulary.getOWLTopDataProperty();
            }

            public OWLEntity visit(OWLAnnotationProperty property) {
                return OWLVocabulary.getTopDatatype();
            }

            public OWLEntity visit(OWLNamedIndividual individual) {
                return OWLVocabulary.getOWLThing();
            }

            public OWLEntity visit(OWLDatatype dataType) {
                return OWLVocabulary.getTopDatatype();
            }
        });
        Integer toReturn = entityHashCodes.get(representative);
        if (toReturn == null) {
            toReturn = this.createHashCode(representative);
        }
        return toReturn;
    }

    protected int createHashCode(OWLEntity owlEntity) {
        return this.createHashCode(owlEntity, entityHashCodes);
    }

    public Integer visit(OWLObjectIntersectionOf description) {
        return this.getNaryBooleanClassDescriptionHasCode((OWLNaryBooleanClassExpression)description);
    }

    private int getNaryBooleanClassDescriptionHasCode(OWLNaryBooleanClassExpression description) {
        return this.getOWLConstructHashCode(OWLConstruct.getOWLConstruct((OWLClassExpression)description)) * this.getCollectionHashCode(description.operands());
    }

    private int getOWLConstructHashCode(OWLConstruct owlConstruct) {
        Integer toReturn = constructHashCodes.get((Object)owlConstruct);
        if (toReturn == null) {
            toReturn = this.createHashCode(owlConstruct);
        }
        return toReturn;
    }

    protected int createHashCode(OWLConstruct owlConstruct) {
        return this.createHashCode(owlConstruct, constructHashCodes);
    }

    public Integer visit(OWLObjectUnionOf description) {
        return this.getNaryBooleanClassDescriptionHasCode((OWLNaryBooleanClassExpression)description);
    }

    public Integer visit(OWLObjectComplementOf description) {
        return this.getOWLConstructHashCode(OWLConstruct.getOWLConstruct((OWLClassExpression)description)) * (Integer)description.getOperand().accept((OWLObjectVisitorEx)this);
    }

    public Integer visit(OWLObjectSomeValuesFrom description) {
        return this.getOWLQuantifiedRestrictionHashCode((OWLQuantifiedRestriction<?>)description);
    }

    private int getOWLQuantifiedRestrictionHashCode(OWLQuantifiedRestriction<?> description) {
        return this.getOWLConstructHashCode(OWLConstruct.getOWLConstruct(description)) * (Integer)((OWLPropertyRange)description.getFiller()).accept((OWLObjectVisitorEx)this);
    }

    public Integer visit(OWLObjectAllValuesFrom description) {
        return this.getOWLQuantifiedRestrictionHashCode((OWLQuantifiedRestriction<?>)description);
    }

    public Integer visit(OWLObjectHasValue description) {
        return this.getOWLValueRestricitonHashCode((OWLHasValueRestriction<?>)description);
    }

    private int getOWLValueRestricitonHashCode(OWLHasValueRestriction<?> description) {
        return this.getOWLConstructHashCode(OWLConstruct.getOWLConstruct(description)) * (Integer)description.getProperty().accept((OWLObjectVisitorEx)this) * (Integer)description.getFiller().accept((OWLObjectVisitorEx)this);
    }

    public Integer visit(OWLObjectMinCardinality description) {
        return this.getOWLCardinalityRestrictionHashCode((OWLCardinalityRestriction<?>)description);
    }

    private int getOWLCardinalityRestrictionHashCode(OWLCardinalityRestriction<?> description) {
        return this.getOWLConstructHashCode(OWLConstruct.getOWLConstruct(description)) * this.getIntegerHashCode(description.getCardinality()) * (description.isQualified() ? (Integer)((OWLPropertyRange)description.getFiller()).accept((OWLObjectVisitorEx)this) : 1);
    }

    private int getIntegerHashCode(int cardinality) {
        Integer toReturn = integerHashCodes.get(cardinality);
        if (toReturn == null) {
            toReturn = this.createHashCode(cardinality);
        }
        return toReturn;
    }

    protected int createHashCode(int n) {
        return this.createHashCode(n, integerHashCodes);
    }

    public Integer visit(OWLObjectExactCardinality description) {
        return this.getOWLCardinalityRestrictionHashCode((OWLCardinalityRestriction<?>)description);
    }

    public Integer visit(OWLObjectMaxCardinality descrption) {
        return this.getOWLCardinalityRestrictionHashCode((OWLCardinalityRestriction<?>)descrption);
    }

    public Integer visit(OWLObjectHasSelf description) {
        return this.getOWLConstructHashCode(OWLConstruct.getOWLConstruct((OWLClassExpression)description)) * (Integer)description.getProperty().accept((OWLObjectVisitorEx)this);
    }

    public Integer visit(OWLObjectOneOf description) {
        return this.getOWLConstructHashCode(OWLConstruct.getOWLConstruct((OWLClassExpression)description)) * this.getCollectionHashCode(description.individuals());
    }

    public Integer visit(OWLDataSomeValuesFrom description) {
        return this.getOWLQuantifiedRestrictionHashCode((OWLQuantifiedRestriction<?>)description);
    }

    public Integer visit(OWLDataAllValuesFrom description) {
        return this.getOWLQuantifiedRestrictionHashCode((OWLQuantifiedRestriction<?>)description);
    }

    public Integer visit(OWLDataHasValue description) {
        return this.getOWLValueRestricitonHashCode((OWLHasValueRestriction<?>)description);
    }

    public Integer visit(OWLDataMinCardinality description) {
        return this.getOWLCardinalityRestrictionHashCode((OWLCardinalityRestriction<?>)description);
    }

    public Integer visit(OWLDataExactCardinality description) {
        return this.getOWLCardinalityRestrictionHashCode((OWLCardinalityRestriction<?>)description);
    }

    public Integer visit(OWLDataMaxCardinality description) {
        return this.getOWLCardinalityRestrictionHashCode((OWLCardinalityRestriction<?>)description);
    }

    public Integer visit(OWLDatatype dataType) {
        return this.getOWLEntityHashCode((OWLEntity)dataType);
    }

    private <O> int createHashCode(O key, Map<O, Integer> map) {
        int toReturn = PrimeNumbersUtils.getNextPrime(this.getMaxPrime());
        map.put(key, toReturn);
        StructuralHashFunction.setMaxPrime(toReturn);
        return toReturn;
    }

    public Integer visit(OWLDataComplementOf dataComplementOf) {
        return this.getOWLConstructHashCode(OWLConstruct.getOWLConstruct((OWLDataRange)dataComplementOf)) * (Integer)dataComplementOf.getDataRange().accept((OWLObjectVisitorEx)this);
    }

    public Integer visit(OWLDataOneOf dataOneOf) {
        return this.getOWLConstructHashCode(OWLConstruct.getOWLConstruct((OWLDataRange)dataOneOf)) * this.getCollectionHashCode(dataOneOf.values());
    }

    public Integer visit(OWLDatatypeRestriction dataRangeRestriction) {
        return this.getOWLConstructHashCode(OWLConstruct.getOWLConstruct((OWLDataRange)dataRangeRestriction)) * (Integer)dataRangeRestriction.getDatatype().accept((OWLObjectVisitorEx)this) * this.getCollectionHashCode(dataRangeRestriction.facetRestrictions());
    }

    public Integer visit(OWLLiteral constant) {
        return this.getOWLConstantHashCode();
    }

    private Integer getOWLConstantHashCode() {
        Integer toReturn = entityHashCodes.get(OWLVocabulary.getTopDatatype());
        if (toReturn == null) {
            toReturn = this.createHashCode(OWLVocabulary.getTopDatatype());
        }
        return toReturn;
    }

    public Integer visit(OWLFacetRestriction facet) {
        return this.getOWLConstructHashCode(OWLConstruct.getOWLConstruct(facet)) * (Integer)facet.getFacetValue().accept((OWLObjectVisitorEx)this);
    }

    public Integer visit(OWLObjectProperty property) {
        return this.getOWLEntityHashCode((OWLEntity)property);
    }

    public Integer visit(OWLObjectInverseOf inverse) {
        return this.getOWLConstructHashCode(OWLConstruct.getOWLConstruct(inverse)) * (Integer)inverse.getInverseProperty().accept((OWLObjectVisitorEx)this);
    }

    public Integer visit(OWLDataProperty property) {
        return this.getOWLEntityHashCode((OWLEntity)property);
    }

    public Integer visit(OWLNamedIndividual individual) {
        return this.getOWLEntityHashCode((OWLEntity)individual);
    }

    public Integer visit(OWLOntology ontology) {
        return this.getIRIHashCode(ontology.getOntologyID().getOntologyIRI().orElse(null));
    }

    public int getMaxPrime() {
        return maxPrime;
    }

    private static void setMaxPrime(int maxPrime) {
        StructuralHashFunction.maxPrime = maxPrime;
    }

    @Override
    public int getHashCode(OWLObject owlObject) {
        return (Integer)owlObject.accept((OWLObjectVisitorEx)this);
    }
}

