/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.similarity;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.coode.oppl.utils.ArgCheck;

public class Pair<O> {
    protected final O o1;
    protected final O o2;

    public Pair(O anOWLObject, O anotherOWLObject) {
        this.o1 = ArgCheck.checkNotNull(anOWLObject, "anOWLObject");
        this.o2 = ArgCheck.checkNotNull(anotherOWLObject, "anotherOWLObject");
        if (anotherOWLObject.equals(anOWLObject)) {
            throw new IllegalArgumentException("The pair is meant to be made of two distic entities");
        }
    }

    @Deprecated
    public Set<O> getMembers() {
        return new HashSet<Object>(Arrays.asList(this.o1, this.o2));
    }

    public Stream<O> members() {
        return Stream.of(this.o1, this.o2);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.o1.hashCode() + this.o2.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pair other = (Pair)obj;
        return this.o1.equals(other.o1) && this.o2.equals(other.o2) || this.o1.equals(other.o2) && this.o2.equals(other.o1);
    }

    public static <T> Set<Pair<T>> getAllPossiblePairs(Collection<? extends T> c) {
        HashSet<Pair<T>> toReturn = new HashSet<Pair<T>>();
        for (T t : c) {
            for (T anotherT : c) {
                if (t.equals(anotherT)) continue;
                toReturn.add(new Pair<T>(t, anotherT));
            }
        }
        return toReturn;
    }

    public String toString() {
        return String.format("(%s, %s)", this.o1, this.o2);
    }
}

