/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.semanticweb.owlapi.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.coode.oppl.semanticweb.owlapi.model.OWLPropertyChain;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.model.HasObjectPropertiesInSignature;
import org.semanticweb.owlapi.model.HasSignature;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class OWLPropertyChainImpl
implements OWLPropertyChain {
    private static final long serialVersionUID = 20100L;
    private final List<OWLObjectPropertyExpression> delegate = new ArrayList<OWLObjectPropertyExpression>();

    public OWLPropertyChainImpl(List<? extends OWLObjectPropertyExpression> delegate) {
        this.delegate.addAll((Collection<OWLObjectPropertyExpression>)ArgCheck.checkNotNull(delegate, "delegate"));
        if (delegate.size() < 2) {
            throw new IllegalArgumentException("The list cannot have less than 2 elements");
        }
    }

    @Override
    public List<OWLObjectPropertyExpression> list() {
        return new ArrayList<OWLObjectPropertyExpression>(this.delegate);
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Stream<?> components() {
        return Stream.of(this.delegate);
    }

    public int hashIndex() {
        return 19907;
    }

    public int initHashCode() {
        return this.delegate.hashCode();
    }

    public int typeIndex() {
        return 19907;
    }

    public void accept(OWLObjectVisitor visitor) {
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return null;
    }

    public int compareTo(OWLObject o) {
        return 1;
    }

    public Set<OWLEntity> getSignature() {
        return OWLAPIStreamUtils.asSet(this.delegate.stream().flatMap(HasSignature::signature));
    }

    public boolean containsEntityInSignature(OWLEntity owlEntity) {
        for (OWLObjectPropertyExpression e : this.delegate) {
            if (!e.containsEntityInSignature(owlEntity)) continue;
            return true;
        }
        return false;
    }

    public Set<OWLClass> getClassesInSignature() {
        return Collections.emptySet();
    }

    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature() {
        return Collections.emptySet();
    }

    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    public Set<OWLDatatype> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        return OWLAPIStreamUtils.asSet(this.delegate.stream().flatMap(HasObjectPropertiesInSignature::objectPropertiesInSignature));
    }

    public Set<OWLClassExpression> getNestedClassExpressions() {
        return Collections.emptySet();
    }

    public boolean isBottomEntity() {
        return false;
    }

    public boolean isTopEntity() {
        return false;
    }

    public Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        return Collections.emptySet();
    }
}

