/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.search.solvability;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.coode.oppl.Variable;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.search.solvability.SolvabilitySearchNode;
import org.coode.oppl.search.solvability.SolvabilitySearchNodeVisitor;
import org.coode.oppl.search.solvability.SolvabilitySearchNodeVisitorEx;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;

public class SolvableSearchNode
extends SolvabilitySearchNode {
    private final Set<OWLObject> values = new HashSet<OWLObject>();
    private final Variable<?> variable;

    public SolvableSearchNode(Variable<?> variable, OWLAxiom axiom, BindingNode bindingNode, Collection<? extends OWLObject> values) {
        super(axiom, bindingNode);
        this.variable = ArgCheck.checkNotNull(variable, "variable");
        this.values.addAll(ArgCheck.checkNotNull(values, "values"));
    }

    @Override
    public void accept(SolvabilitySearchNodeVisitor visitor) {
        visitor.visitSolvableSearchNode(this);
    }

    @Override
    public <O> O accept(SolvabilitySearchNodeVisitorEx<O> visitor) {
        return visitor.visitSolvableSearchNode(this);
    }

    @Deprecated
    public Set<OWLObject> getValues() {
        return new HashSet<OWLObject>(this.values);
    }

    public Stream<OWLObject> values() {
        return this.values.stream();
    }

    public Variable<?> getVariable() {
        return this.variable;
    }
}

