/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.search.solvability;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.search.solvability.AxiomSolvability;
import org.coode.oppl.search.solvability.NoSolutionSolvableSearchNode;
import org.coode.oppl.search.solvability.SolvabilitySearchNode;
import org.coode.oppl.search.solvability.SolvabilitySearchNodeVisitorEx;
import org.coode.oppl.search.solvability.SolvableSearchNode;
import org.coode.oppl.search.solvability.SolvedSearchNode;
import org.coode.oppl.search.solvability.UnsolvableSearchNode;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.model.OWLAxiom;

public class MultipleAxiomSolvability
implements AxiomSolvability {
    private final Set<AxiomSolvability> delegates = new HashSet<AxiomSolvability>();
    private static final FalseUnsolvable FALSE_UNSOLVABLE = new FalseUnsolvable();

    public MultipleAxiomSolvability(Collection<? extends AxiomSolvability> delegates) {
        this.delegates.addAll(ArgCheck.checkNotNull(delegates, "delegates"));
        if (delegates.isEmpty()) {
            throw new IllegalArgumentException("The delegate collection canont be empty");
        }
    }

    @Override
    public SolvabilitySearchNode getSolvabilitySearchNode(OWLAxiom owlAxiom, BindingNode bindingNode) {
        boolean solved = false;
        Iterator<AxiomSolvability> iterator = this.delegates.iterator();
        SolvabilitySearchNode toReturn = null;
        while (!solved && iterator.hasNext()) {
            AxiomSolvability axiomSolvability = iterator.next();
            toReturn = axiomSolvability.getSolvabilitySearchNode(owlAxiom, bindingNode);
            solved = toReturn != null && toReturn.accept(FALSE_UNSOLVABLE) != false;
        }
        return toReturn;
    }

    @Deprecated
    public Set<AxiomSolvability> getDelegates() {
        return new HashSet<AxiomSolvability>(this.delegates);
    }

    public Stream<AxiomSolvability> delegates() {
        return this.delegates.stream();
    }

    static class FalseUnsolvable
    implements SolvabilitySearchNodeVisitorEx<Boolean> {
        FalseUnsolvable() {
        }

        @Override
        public Boolean visitSolvableSearchNode(SolvableSearchNode solvableSearchNode) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visitSolvedSearchNode(SolvedSearchNode solvedSearchNode) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visitNoSolutionSolvableSearchNode(NoSolutionSolvableSearchNode noSolutionSolvableSearchNode) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visitUnsolvableSearchNode(UnsolvableSearchNode unsolvableSearchNode) {
            return Boolean.FALSE;
        }
    }
}

