/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.search.solvability;

import java.util.Set;
import java.util.stream.Stream;
import org.coode.oppl.search.solvability.QuerySolver;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public final class InferredModelQuerySolver
implements QuerySolver {
    private final OWLReasoner reasoner;

    public InferredModelQuerySolver(OWLReasoner reasoner) {
        this.reasoner = ArgCheck.checkNotNull(reasoner, "reasoner");
    }

    @Override
    public Set<OWLClass> getSubClasses(OWLClassExpression superClass) {
        Set toReturn = OWLAPIStreamUtils.asSet((Stream)this.reasoner.getSubClasses(superClass, false).entities());
        this.reasoner.getEquivalentClasses(superClass).forEach(toReturn::add);
        if (!superClass.isAnonymous()) {
            toReturn.add(superClass.asOWLClass());
        }
        return toReturn;
    }

    @Override
    public Set<OWLClass> getSuperClasses(OWLClassExpression subClass) {
        Set toReturn = OWLAPIStreamUtils.asSet((Stream)this.reasoner.getSuperClasses(subClass, false).entities());
        this.reasoner.getEquivalentClasses(subClass).forEach(toReturn::add);
        if (!subClass.isAnonymous()) {
            toReturn.add(subClass.asOWLClass());
        }
        return toReturn;
    }

    @Override
    public boolean hasNoSubClass(OWLClassExpression superClass) {
        Set subClasses = OWLAPIStreamUtils.asSet((Stream)this.reasoner.getSubClasses(superClass, false).entities());
        this.reasoner.getEquivalentClasses(superClass).forEach(subClasses::add);
        subClasses.remove(superClass);
        this.reasoner.getBottomClassNode().forEach(subClasses::remove);
        return subClasses.isEmpty();
    }

    @Override
    public boolean hasNoSuperClass(OWLClassExpression subClass) {
        Set superClasses = OWLAPIStreamUtils.asSet((Stream)this.reasoner.getSubClasses(subClass, false).entities());
        this.reasoner.getEquivalentClasses(subClass).forEach(superClasses::add);
        superClasses.remove(subClass);
        this.reasoner.getTopClassNode().forEach(superClasses::remove);
        return superClasses.isEmpty();
    }

    @Override
    public Set<OWLNamedIndividual> getNamedFillers(OWLNamedIndividual subject, OWLObjectPropertyExpression objectProperty) {
        return OWLAPIStreamUtils.asSet((Stream)this.reasoner.getObjectPropertyValues(subject, objectProperty).entities());
    }
}

