/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.search.solvability;

import java.util.Arrays;
import java.util.Set;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.Variable;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.search.solvability.AbstractSolvabilityOPPLOWLAxiomSearchTree;
import org.coode.oppl.search.solvability.AssertedModelQuerySolver;
import org.coode.oppl.search.solvability.AxiomSolvability;
import org.coode.oppl.search.solvability.MultipleAxiomSolvability;
import org.coode.oppl.search.solvability.NoResultsAxiomSolvability;
import org.coode.oppl.search.solvability.OWLClassSubClassOfAxiomSolvability;
import org.coode.oppl.search.solvability.OWLObjectPropertyFillersAxiomSolvability;
import org.coode.oppl.search.solvability.UnsolvableSearchNode;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.utils.VariableExtractor;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class AssertedSolvabilitySearchTree
extends AbstractSolvabilityOPPLOWLAxiomSearchTree {
    private final OWLOntologyManager ontologyManager;

    public AssertedSolvabilitySearchTree(ConstraintSystem constraintSystem, OWLOntologyManager ontologyManager, RuntimeExceptionHandler runtimeExceptionHandler) {
        super(constraintSystem, runtimeExceptionHandler);
        this.ontologyManager = ArgCheck.checkNotNull(ontologyManager, "ontologyManager");
    }

    @Override
    protected AxiomSolvability getAxiomSolvability() {
        AssertedModelQuerySolver querySolver = new AssertedModelQuerySolver(this.getOntologyManager());
        return new MultipleAxiomSolvability(Arrays.asList(new OWLClassSubClassOfAxiomSolvability(this.getConstraintSystem(), querySolver), new NoResultsAxiomSolvability(this.getConstraintSystem(), querySolver), new OWLObjectPropertyFillersAxiomSolvability(this.getConstraintSystem(), querySolver)));
    }

    @Override
    protected boolean goalReachedUnsolvabelNode(UnsolvableSearchNode unsolvableSearchNode) {
        VariableExtractor variableExtractor = new VariableExtractor(this.getConstraintSystem(), true);
        Set<Variable<?>> extractVariables = variableExtractor.extractVariables((OWLObject)unsolvableSearchNode.getAxiom());
        return extractVariables.isEmpty() ? this.findAxiom(unsolvableSearchNode.getAxiom()) : false;
    }

    private boolean findAxiom(OWLAxiom axiom) {
        return this.getConstraintSystem().getOntologyManager().ontologies().anyMatch(o -> o.containsAxiom(axiom));
    }

    public OWLOntologyManager getOntologyManager() {
        return this.ontologyManager;
    }
}

