/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.search.solvability;

import java.util.Set;
import org.coode.oppl.search.solvability.QuerySolver;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public final class AssertedModelQuerySolver
implements QuerySolver {
    private final OWLOntologyManager ontologyManager;

    public AssertedModelQuerySolver(OWLOntologyManager ontologyManager) {
        this.ontologyManager = ArgCheck.checkNotNull(ontologyManager, "ontologyManager");
    }

    @Override
    public Set<OWLClass> getSubClasses(OWLClassExpression superClass) {
        return OWLAPIStreamUtils.asSet(this.ontologyManager.ontologies().flatMap(o -> o.axioms(AxiomType.SUBCLASS_OF)).filter(owlAxiom -> owlAxiom.getSuperClass().equals(superClass) && !owlAxiom.getSubClass().isAnonymous()).map(a -> a.getSubClass().asOWLClass()));
    }

    @Override
    public Set<OWLClass> getSuperClasses(OWLClassExpression subClass) {
        return OWLAPIStreamUtils.asSet(this.ontologyManager.ontologies().flatMap(o -> o.axioms(AxiomType.SUBCLASS_OF)).filter(owlAxiom -> owlAxiom.getSubClass().equals(subClass) && !owlAxiom.getSuperClass().isAnonymous()).map(a -> a.getSuperClass().asOWLClass()));
    }

    @Override
    public Set<OWLNamedIndividual> getNamedFillers(OWLNamedIndividual subject, OWLObjectPropertyExpression objectProperty) {
        return OWLAPIStreamUtils.asSet(this.ontologyManager.ontologies().flatMap(o -> o.axioms(AxiomType.OBJECT_PROPERTY_ASSERTION)).filter(ax -> ax.getSubject().equals(subject) && ((OWLObjectPropertyExpression)ax.getProperty()).equals(objectProperty) && !((OWLIndividual)ax.getObject()).isAnonymous()).map(ax -> ((OWLIndividual)ax.getObject()).asOWLNamedIndividual()));
    }

    @Override
    public boolean hasNoSubClass(OWLClassExpression superClass) {
        return this.ontologyManager.ontologies().flatMap(o -> o.axioms(AxiomType.SUBCLASS_OF)).noneMatch(a -> a.getSuperClass().equals(superClass));
    }

    @Override
    public boolean hasNoSuperClass(OWLClassExpression subClass) {
        return this.ontologyManager.ontologies().flatMap(o -> o.axioms(AxiomType.SUBCLASS_OF)).noneMatch(a -> a.getSubClass().equals(subClass));
    }
}

