/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.coode.oppl.PartialOWLObjectInstantiator;
import org.coode.oppl.Variable;
import org.coode.oppl.VariableVisitorEx;
import org.coode.oppl.bindingtree.Assignment;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.generated.GeneratedVariable;
import org.coode.oppl.generated.RegexpGeneratedVariable;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.coode.oppl.search.SearchTree;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.utils.OWLObjectExtractor;
import org.coode.oppl.utils.VariableExtractor;
import org.coode.oppl.variabletypes.ANNOTATIONPROPERTYVariableType;
import org.coode.oppl.variabletypes.CLASSVariableType;
import org.coode.oppl.variabletypes.CONSTANTVariableType;
import org.coode.oppl.variabletypes.DATAPROPERTYVariableType;
import org.coode.oppl.variabletypes.INDIVIDUALVariableType;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.oppl.variabletypes.OBJECTPROPERTYVariableType;
import org.coode.oppl.variabletypes.VariableTypeVisitorEx;
import org.semanticweb.owlapi.model.HasAnnotationPropertiesInSignature;
import org.semanticweb.owlapi.model.HasAxioms;
import org.semanticweb.owlapi.model.HasClassesInSignature;
import org.semanticweb.owlapi.model.HasDataPropertiesInSignature;
import org.semanticweb.owlapi.model.HasIndividualsInSignature;
import org.semanticweb.owlapi.model.HasObjectPropertiesInSignature;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class OWLAxiomSearchTree
extends SearchTree<OWLAxiom> {
    private final AssignableFinder finder = new AssignableFinder();
    private final ValueComputationParameters parameters;
    protected final VariableTypeVisitorEx<Set<? extends OWLObject>> assignableValuesVisitor = new VariableTypeVisitorEx<Set<? extends OWLObject>>(){

        @Override
        public Set<? extends OWLObject> visitCLASSVariableType(CLASSVariableType classVariableType) {
            return OWLAxiomSearchTree.this.getAllClasses();
        }

        @Override
        public Set<? extends OWLObject> visitOBJECTPROPERTYVariableType(OBJECTPROPERTYVariableType objectpropertyVariableType) {
            return OWLAxiomSearchTree.this.getObjectProperties();
        }

        @Override
        public Set<? extends OWLObject> visitDATAPROPERTYVariableType(DATAPROPERTYVariableType datapropertyVariableType) {
            return OWLAxiomSearchTree.this.getAllDataProperties();
        }

        @Override
        public Set<? extends OWLObject> visitANNOTATIONPROPERTYVariableType(ANNOTATIONPROPERTYVariableType annotationpropertyVariableType) {
            return OWLAxiomSearchTree.this.getAllAnnotationProperties();
        }

        @Override
        public Set<? extends OWLObject> visitINDIVIDUALVariableType(INDIVIDUALVariableType individualVariableType) {
            return OWLAxiomSearchTree.this.getAllIndividuals();
        }

        @Override
        public Set<? extends OWLObject> visitCONSTANTVariableType(CONSTANTVariableType constantVariableType) {
            return OWLAxiomSearchTree.this.getAllConstants();
        }
    };

    public OWLAxiomSearchTree(ValueComputationParameters parameters) {
        this.parameters = ArgCheck.checkNotNull(parameters, "parameters");
    }

    public ValueComputationParameters getParameters() {
        return this.parameters;
    }

    @Override
    protected List<OWLAxiom> getChildren(OWLAxiom node) {
        Set<BindingNode> leaves = this.getParameters().getConstraintSystem().getLeaves();
        ArrayList<OWLAxiom> toReturn = new ArrayList<OWLAxiom>();
        VariableExtractor variableExtractor = new VariableExtractor(this.getParameters().getConstraintSystem(), false);
        Set<Variable<?>> variables = variableExtractor.extractVariables((OWLObject)node);
        if (!variables.isEmpty()) {
            Variable<?> variable = variables.iterator().next();
            HashSet<Object> values = new HashSet<Object>();
            if (leaves == null) {
                values.addAll(this.getAssignableValues(variable));
            } else {
                for (BindingNode bindingNode : leaves) {
                    SimpleValueComputationParameters pars = new SimpleValueComputationParameters(this.getParameters().getConstraintSystem(), bindingNode, this.getParameters().getRuntimeExceptionHandler());
                    if (bindingNode.containsAssignedVariable(variable)) {
                        values.add(this.getParameters().getBindingNode().getAssignmentValue(variable, pars));
                        continue;
                    }
                    values.addAll(this.getAssignableValues(variable));
                }
            }
            for (OWLObject oWLObject : values) {
                Assignment assignment = new Assignment(variable, oWLObject);
                BindingNode bindingNode = new BindingNode(Collections.singleton(assignment), variables.stream());
                SimpleValueComputationParameters par = new SimpleValueComputationParameters(this.getParameters().getConstraintSystem(), bindingNode, this.getParameters().getRuntimeExceptionHandler());
                PartialOWLObjectInstantiator instantiator = new PartialOWLObjectInstantiator(par);
                toReturn.add((OWLAxiom)node.accept((OWLObjectVisitorEx)instantiator));
            }
        }
        return toReturn;
    }

    @Override
    protected boolean goalReached(OWLAxiom start) {
        return this.ontologies().anyMatch(o -> o.containsAxiom(start));
    }

    protected Set<OWLClass> getAllClasses() {
        return OWLAPIStreamUtils.asSet(this.ontologies().flatMap(HasClassesInSignature::classesInSignature));
    }

    protected Set<OWLLiteral> getAllConstants() {
        return OWLAPIStreamUtils.asSet(this.ontologies().flatMap(HasAxioms::axioms).flatMap(OWLObjectExtractor::getAllOWLLiterals));
    }

    protected Set<OWLDataProperty> getAllDataProperties() {
        return OWLAPIStreamUtils.asSet(this.ontologies().flatMap(HasDataPropertiesInSignature::dataPropertiesInSignature));
    }

    protected Stream<OWLOntology> ontologies() {
        return this.getParameters().getConstraintSystem().getOntologyManager().ontologies();
    }

    protected Set<OWLAnnotationProperty> getAllAnnotationProperties() {
        return OWLAPIStreamUtils.asSet(this.ontologies().flatMap(HasAnnotationPropertiesInSignature::annotationPropertiesInSignature));
    }

    protected Set<OWLNamedIndividual> getAllIndividuals() {
        return OWLAPIStreamUtils.asSet(this.ontologies().flatMap(HasIndividualsInSignature::individualsInSignature));
    }

    private Collection<? extends OWLObject> getAssignableValues(Variable<?> variable) {
        return variable.accept(this.finder);
    }

    protected Set<OWLObjectProperty> getObjectProperties() {
        return OWLAPIStreamUtils.asSet(this.ontologies().flatMap(HasObjectPropertiesInSignature::objectPropertiesInSignature));
    }

    public VariableTypeVisitorEx<Set<? extends OWLObject>> getAssignableValuesVisitor() {
        return this.assignableValuesVisitor;
    }

    class AssignableFinder
    implements VariableVisitorEx<Set<? extends OWLObject>> {
        AssignableFinder() {
        }

        @Override
        public <O extends OWLObject> Set<? extends OWLObject> visit(InputVariable<O> v) {
            return v.getType().accept(OWLAxiomSearchTree.this.assignableValuesVisitor);
        }

        @Override
        public <O extends OWLObject> Set<? extends OWLObject> visit(RegexpGeneratedVariable<O> v) {
            Set<? extends OWLObject> result = v.getType().accept(OWLAxiomSearchTree.this.assignableValuesVisitor);
            Iterator<? extends OWLObject> iterator = result.iterator();
            while (iterator.hasNext()) {
                OWLObject owlObject = iterator.next();
                ManchesterSyntaxRenderer renderer = OWLAxiomSearchTree.this.getParameters().getConstraintSystem().getOPPLFactory().getManchesterSyntaxRenderer(OWLAxiomSearchTree.this.getParameters().getConstraintSystem());
                owlObject.accept((OWLObjectVisitor)renderer);
                if (v.getPatternGeneratingOPPLFunction().compute(OWLAxiomSearchTree.this.getParameters()).matcher(renderer.toString()).matches()) continue;
                iterator.remove();
            }
            return result;
        }

        @Override
        public <O extends OWLObject> Set<? extends OWLObject> visit(GeneratedVariable<O> v) {
            return Collections.emptySet();
        }
    }
}

