/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.search;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.coode.oppl.VariableVisitorEx;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.generated.GeneratedVariable;
import org.coode.oppl.generated.RegexpGeneratedVariable;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.oppl.variabletypes.VariableTypeVisitorEx;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;

public final class AssignableValueExtractor
implements VariableVisitorEx<Set<? extends OWLObject>> {
    private final VariableTypeVisitorEx<Set<? extends OWLObject>> assignableValuesVisitor;
    private final ValueComputationParameters parameters;

    public AssignableValueExtractor(VariableTypeVisitorEx<Set<? extends OWLObject>> assignableValuesVisitor, ValueComputationParameters parameters) {
        this.assignableValuesVisitor = ArgCheck.checkNotNull(assignableValuesVisitor, "assignableValuesVisitor");
        this.parameters = ArgCheck.checkNotNull(parameters, "parameters");
    }

    @Override
    public <O extends OWLObject> Set<? extends OWLObject> visit(InputVariable<O> v) {
        return v.getType().accept(this.assignableValuesVisitor);
    }

    @Override
    public <O extends OWLObject> Set<? extends OWLObject> visit(RegexpGeneratedVariable<O> v) {
        Set<? extends OWLObject> toReturn = v.getType().accept(this.assignableValuesVisitor);
        Iterator<? extends OWLObject> iterator = toReturn.iterator();
        while (iterator.hasNext()) {
            OWLObject owlObject = iterator.next();
            ManchesterSyntaxRenderer renderer = this.getParameters().getConstraintSystem().getOPPLFactory().getManchesterSyntaxRenderer(this.getParameters().getConstraintSystem());
            owlObject.accept((OWLObjectVisitor)renderer);
            Pattern pattern = v.getPatternGeneratingOPPLFunction().compute(this.getParameters());
            if (pattern.matcher(renderer.toString()).matches()) continue;
            iterator.remove();
        }
        return toReturn;
    }

    @Override
    public <O extends OWLObject> Set<? extends OWLObject> visit(GeneratedVariable<O> v) {
        return Collections.emptySet();
    }

    public ValueComputationParameters getParameters() {
        return this.parameters;
    }
}

