/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.PartialOWLObjectInstantiator;
import org.coode.oppl.Variable;
import org.coode.oppl.VariableScope;
import org.coode.oppl.bindingtree.Assignment;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.log.Logging;
import org.coode.oppl.queryplanner.ConstantExtractor;
import org.coode.oppl.search.AssignableValueExtractor;
import org.coode.oppl.search.OPPLOWLAxiomSearchNode;
import org.coode.oppl.search.SearchTree;
import org.coode.oppl.utils.AbstractVariableVisitorExAdapter;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.utils.ConstantCollector;
import org.coode.oppl.utils.VariableExtractor;
import org.coode.oppl.variabletypes.ANNOTATIONPROPERTYVariableType;
import org.coode.oppl.variabletypes.CLASSVariableType;
import org.coode.oppl.variabletypes.CONSTANTVariableType;
import org.coode.oppl.variabletypes.DATAPROPERTYVariableType;
import org.coode.oppl.variabletypes.INDIVIDUALVariableType;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.oppl.variabletypes.OBJECTPROPERTYVariableType;
import org.coode.oppl.variabletypes.VariableTypeVisitorEx;
import org.semanticweb.owlapi.model.HasAnnotationPropertiesInSignature;
import org.semanticweb.owlapi.model.HasAxioms;
import org.semanticweb.owlapi.model.HasClassesInSignature;
import org.semanticweb.owlapi.model.HasDataPropertiesInSignature;
import org.semanticweb.owlapi.model.HasIndividualsInSignature;
import org.semanticweb.owlapi.model.HasObjectPropertiesInSignature;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public abstract class AbstractOPPLAxiomSearchTree
extends SearchTree<OPPLOWLAxiomSearchNode> {
    private final ConstraintSystem constraintSystem;
    private final RuntimeExceptionHandler runtimeExceptionHandler;
    protected final Set<OWLClass> allClasses = new HashSet<OWLClass>();
    protected final Set<OWLObjectProperty> allObjectProperties = new HashSet<OWLObjectProperty>();
    protected final Set<OWLAnnotationProperty> allAnnotationProperties = new HashSet<OWLAnnotationProperty>();
    protected final Set<OWLDataProperty> allDataProperties = new HashSet<OWLDataProperty>();
    protected final Set<OWLIndividual> allIndividuals = new HashSet<OWLIndividual>();
    protected final Set<OWLLiteral> allConstants = new HashSet<OWLLiteral>();
    private final VariableTypeVisitorEx<Set<? extends OWLObject>> assignableValuesVisitor = new VariableTypeVisitorEx<Set<? extends OWLObject>>(){

        @Override
        public Set<? extends OWLObject> visitCLASSVariableType(CLASSVariableType classVariableType) {
            return AbstractOPPLAxiomSearchTree.this.allClasses;
        }

        @Override
        public Set<? extends OWLObject> visitOBJECTPROPERTYVariableType(OBJECTPROPERTYVariableType objectpropertyVariableType) {
            return AbstractOPPLAxiomSearchTree.this.allObjectProperties;
        }

        @Override
        public Set<? extends OWLObject> visitDATAPROPERTYVariableType(DATAPROPERTYVariableType datapropertyVariableType) {
            return AbstractOPPLAxiomSearchTree.this.allDataProperties;
        }

        @Override
        public Set<? extends OWLObject> visitINDIVIDUALVariableType(INDIVIDUALVariableType individualVariableType) {
            return AbstractOPPLAxiomSearchTree.this.allIndividuals;
        }

        @Override
        public Set<? extends OWLObject> visitCONSTANTVariableType(CONSTANTVariableType constantVariableType) {
            return AbstractOPPLAxiomSearchTree.this.allConstants;
        }

        @Override
        public Set<? extends OWLObject> visitANNOTATIONPROPERTYVariableType(ANNOTATIONPROPERTYVariableType annotationpropertyVariableType) {
            return AbstractOPPLAxiomSearchTree.this.allAnnotationProperties;
        }
    };

    protected AbstractOPPLAxiomSearchTree(ConstraintSystem constraintSystem, RuntimeExceptionHandler runtimeExceptionHandler) {
        this.constraintSystem = ArgCheck.checkNotNull(constraintSystem, "constraintSystem");
        this.runtimeExceptionHandler = ArgCheck.checkNotNull(runtimeExceptionHandler, "runtimeExceptionHandler");
    }

    @Override
    protected abstract boolean goalReached(OPPLOWLAxiomSearchNode var1);

    @Override
    protected List<OPPLOWLAxiomSearchNode> getChildren(OPPLOWLAxiomSearchNode node) {
        ArrayList<OPPLOWLAxiomSearchNode> toReturn = new ArrayList<OPPLOWLAxiomSearchNode>();
        Set<Variable<?>> variables = node.getBinding().getUnassignedVariables();
        BindingNode binding = node.getBinding();
        SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(this.getConstraintSystem(), node.getBinding(), this.getRuntimeExceptionHandler());
        if (!variables.isEmpty()) {
            Variable<?> variable = variables.iterator().next();
            for (OWLObject oWLObject : this.getAssignableValues(variable, parameters)) {
                Assignment assignment = new Assignment(variable, oWLObject);
                BindingNode childBinding = new BindingNode(binding);
                childBinding.addAssignment(assignment);
                SimpleValueComputationParameters newParameters = new SimpleValueComputationParameters(this.getConstraintSystem(), childBinding, this.getRuntimeExceptionHandler());
                PartialOWLObjectInstantiator instantiator = new PartialOWLObjectInstantiator(newParameters);
                OWLAxiom instantiatedAxiom = (OWLAxiom)node.getAxiom().accept((OWLObjectVisitorEx)instantiator);
                OPPLOWLAxiomSearchNode child = new OPPLOWLAxiomSearchNode(instantiatedAxiom, childBinding);
                toReturn.add(child);
            }
        }
        return toReturn;
    }

    private Collection<OWLClass> getAllClasses() {
        return OWLAPIStreamUtils.asSet(this.getConstraintSystem().getOntologyManager().ontologies().flatMap(HasClassesInSignature::classesInSignature));
    }

    private Collection<OWLLiteral> getAllConstants() {
        HashSet<OWLLiteral> toReturn = new HashSet<OWLLiteral>();
        ConstantExtractor constantExtractor = new ConstantExtractor(toReturn);
        ConstantCollector visitor = new ConstantCollector(toReturn, (OWLClassExpressionVisitor)constantExtractor);
        this.getConstraintSystem().getOntologyManager().ontologies().flatMap(HasAxioms::axioms).forEach(a -> a.accept((OWLAxiomVisitor)visitor));
        return toReturn;
    }

    private Collection<OWLDataProperty> getAllDataProperties() {
        return OWLAPIStreamUtils.asSet(this.getConstraintSystem().getOntologyManager().ontologies().flatMap(HasDataPropertiesInSignature::dataPropertiesInSignature));
    }

    private Collection<OWLIndividual> getAllIndividuals() {
        return OWLAPIStreamUtils.asSet(this.getConstraintSystem().getOntologyManager().ontologies().flatMap(HasIndividualsInSignature::individualsInSignature));
    }

    private Collection<? extends OWLObject> getAssignableValues(Variable<?> variable, ValueComputationParameters parameters) {
        return OWLAPIStreamUtils.asSet(variable.accept(new AssignableValueExtractor(this.assignableValuesVisitor, parameters)).stream().filter(o -> variable.accept(new ScopeChecker(Boolean.TRUE, (OWLObject)o))));
    }

    private void initAssignableValues() {
        this.allClasses.addAll(this.getAllClasses());
        Logging.getQueryLogger().fine("Possible class values ", (Object)this.allClasses.size());
        this.allDataProperties.addAll(this.getAllDataProperties());
        Logging.getQueryLogger().fine("Possible data property values ", (Object)this.allDataProperties.size());
        this.allObjectProperties.addAll(this.getObjectProperties());
        Logging.getQueryLogger().fine("Possible object property values ", (Object)this.allObjectProperties.size());
        this.allIndividuals.addAll(this.getAllIndividuals());
        Logging.getQueryLogger().fine("Possible individual  values ", (Object)this.allIndividuals.size());
        this.allConstants.addAll(this.getAllConstants());
        Logging.getQueryLogger().fine("Possible constant  values ", (Object)this.allConstants.size());
        this.allAnnotationProperties.addAll(this.getAllAnnotationProperties());
        Logging.getQueryLogger().fine("Possible annotation properties values ", (Object)this.allAnnotationProperties.size());
    }

    private Set<OWLAnnotationProperty> getAllAnnotationProperties() {
        return OWLAPIStreamUtils.asSet(this.getConstraintSystem().getOntologyManager().ontologies().flatMap(HasAnnotationPropertiesInSignature::annotationPropertiesInSignature));
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    private Collection<OWLObjectProperty> getObjectProperties() {
        return OWLAPIStreamUtils.asSet(this.getConstraintSystem().getOntologyManager().ontologies().flatMap(HasObjectPropertiesInSignature::objectPropertiesInSignature));
    }

    @Override
    public boolean exhaustiveSearchTree(OPPLOWLAxiomSearchNode start, List<List<OPPLOWLAxiomSearchNode>> solutions) {
        this.initAssignableValues();
        if (this.getConstraintSystem().leavesCount() > 0) {
            AtomicBoolean found = new AtomicBoolean(false);
            Logging.getQueryTestLogging().fine("Existing leaves count: ", (Object)this.getConstraintSystem().leavesCount());
            this.getConstraintSystem().leaves().forEach(bindingNode -> found.compareAndSet(false, this.nextElement(start, solutions, (BindingNode)bindingNode)));
            return found.get();
        }
        return super.exhaustiveSearchTree(start, solutions);
    }

    protected boolean nextElement(OPPLOWLAxiomSearchNode start, List<List<OPPLOWLAxiomSearchNode>> solutions, BindingNode bindingNode) {
        ArrayList bindingNodeSolutions;
        SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(this.getConstraintSystem(), bindingNode, this.getRuntimeExceptionHandler());
        PartialOWLObjectInstantiator partialObjectInstantiator = new PartialOWLObjectInstantiator(parameters);
        OWLAxiom newStartAxiom = (OWLAxiom)start.getAxiom().accept((OWLObjectVisitorEx)partialObjectInstantiator);
        VariableExtractor variableExtractor = new VariableExtractor(this.getConstraintSystem(), false);
        BindingNode newBindingNode = new BindingNode(bindingNode.getAssignments(), variableExtractor.extractVariables((OWLObject)newStartAxiom).stream());
        OPPLOWLAxiomSearchNode newStart = new OPPLOWLAxiomSearchNode(newStartAxiom, newBindingNode);
        boolean bindingNodeSearch = super.exhaustiveSearchTree(newStart, bindingNodeSolutions = new ArrayList());
        if (bindingNodeSearch) {
            solutions.addAll(bindingNodeSolutions);
        }
        return bindingNodeSearch;
    }

    public RuntimeExceptionHandler getRuntimeExceptionHandler() {
        return this.runtimeExceptionHandler;
    }

    class ScopeChecker
    extends AbstractVariableVisitorExAdapter<Boolean> {
        private final OWLObject owlObject;

        ScopeChecker(Boolean defaultValue, OWLObject owlObject) {
            super(defaultValue);
            this.owlObject = owlObject;
        }

        @Override
        public <P extends OWLObject> Boolean visit(InputVariable<P> v) {
            VariableScope<?> variableScope = v.getVariableScope();
            try {
                return variableScope == null || variableScope.check(this.owlObject);
            }
            catch (OWLRuntimeException e) {
                AbstractOPPLAxiomSearchTree.this.getRuntimeExceptionHandler().handleOWLRuntimeException(e);
                return Boolean.FALSE;
            }
        }
    }
}

