/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.queryplanner;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.coode.oppl.ConstraintVisitor;
import org.coode.oppl.InCollectionConstraint;
import org.coode.oppl.InequalityConstraint;
import org.coode.oppl.NAFConstraint;
import org.coode.oppl.RegExpConstraint;
import org.coode.oppl.Variable;
import org.coode.oppl.queryplanner.AssertedAxiomPlannerItem;
import org.coode.oppl.queryplanner.ConstraintQueryPlannerItem;
import org.coode.oppl.queryplanner.InferredAxiomQueryPlannerItem;
import org.coode.oppl.queryplanner.QueryPlannerVisitorEx;
import org.coode.oppl.utils.VariableExtractor;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class QueryItemVariableExtractor
implements QueryPlannerVisitorEx<Set<Variable<?>>> {
    @Override
    public Set<Variable<?>> visitConstraintQueryPlannerItem(ConstraintQueryPlannerItem constraintQueryPlannerItem) {
        final HashSet toReturn = new HashSet();
        final VariableExtractor variableExtractor = new VariableExtractor(constraintQueryPlannerItem.getConstraintSystem(), false);
        constraintQueryPlannerItem.getConstraint().accept(new ConstraintVisitor(){

            @Override
            public void visitInequalityConstraint(InequalityConstraint c) {
                toReturn.add(c.getVariable());
                toReturn.addAll(variableExtractor.extractVariables(c.getExpression()));
            }

            public void visitInCollectionConstraint(InCollectionConstraint<? extends OWLObject> c) {
                toReturn.add(c.getVariable());
                OWLAPIStreamUtils.add((Collection)toReturn, c.collection().flatMap(v -> variableExtractor.extractVariables((OWLObject)v).stream()));
            }

            @Override
            public void visitInCollectionConstraint(RegExpConstraint c) {
                toReturn.add(c.getVariable());
                toReturn.addAll(variableExtractor.extractVariables(c.getExpression()));
            }

            @Override
            public void visit(NAFConstraint nafConstraint) {
                toReturn.addAll(variableExtractor.extractVariables((OWLObject)nafConstraint.getAxiom()));
            }
        });
        return toReturn;
    }

    @Override
    public Set<Variable<?>> visitAssertedAxiomPlannerItem(AssertedAxiomPlannerItem assertedAxiomPlannerItem) {
        VariableExtractor variableExtractor = new VariableExtractor(assertedAxiomPlannerItem.getConstraintSystem(), false);
        return variableExtractor.extractVariables((OWLObject)assertedAxiomPlannerItem.getAxiom());
    }

    @Override
    public Set<Variable<?>> visitInferredAxiomQueryPlannerItem(InferredAxiomQueryPlannerItem inferredAxiomQueryPlannerItem) {
        VariableExtractor variableExtractor = new VariableExtractor(inferredAxiomQueryPlannerItem.getConstraintSystem(), false);
        return variableExtractor.extractVariables((OWLObject)inferredAxiomQueryPlannerItem.getAxiom());
    }
}

