/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.queryplanner;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.ExecutionMonitor;
import org.coode.oppl.PartialOWLObjectInstantiator;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.log.Logging;
import org.coode.oppl.querymatching.AbstractAxiomQuery;
import org.coode.oppl.querymatching.AssertedSolvabilityBasedAxiomQuery;
import org.coode.oppl.querymatching.InferredSolvabilityBasedTreeSearchAxiomQuery;
import org.coode.oppl.queryplanner.AbstractQueryPlannerItem;
import org.coode.oppl.queryplanner.QueryPlannerVisitor;
import org.coode.oppl.queryplanner.QueryPlannerVisitorEx;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class InferredAxiomQueryPlannerItem
extends AbstractQueryPlannerItem {
    private final OWLAxiom axiom;

    public InferredAxiomQueryPlannerItem(ConstraintSystem constraintSystem, OWLAxiom axiom) {
        super(constraintSystem);
        this.axiom = ArgCheck.checkNotNull(axiom, "axiom");
    }

    public OWLAxiom getAxiom() {
        return this.axiom;
    }

    @Override
    public Set<BindingNode> match(Collection<? extends BindingNode> currentLeaves, ExecutionMonitor executionMonitor, RuntimeExceptionHandler runtimeExceptionHandler) {
        HashSet<BindingNode> toReturn = new HashSet<BindingNode>();
        if (currentLeaves != null) {
            Iterator<? extends BindingNode> iterator = currentLeaves.iterator();
            while (!executionMonitor.isCancelled() && iterator.hasNext()) {
                BindingNode bindingNode = iterator.next();
                SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(this.getConstraintSystem(), bindingNode, runtimeExceptionHandler);
                PartialOWLObjectInstantiator instantiator = new PartialOWLObjectInstantiator(parameters);
                OWLAxiom instantiatedAxiom = (OWLAxiom)this.getAxiom().accept((OWLObjectVisitorEx)instantiator);
                Set<BindingNode> newLeaves = this.updateBindings(instantiatedAxiom, runtimeExceptionHandler);
                toReturn.addAll(this.merge(bindingNode, newLeaves));
            }
            if (executionMonitor.isCancelled()) {
                toReturn = null;
            }
        } else {
            toReturn.addAll(this.updateBindings(this.getAxiom(), runtimeExceptionHandler));
        }
        return toReturn;
    }

    private Set<BindingNode> updateBindings(OWLAxiom ax, RuntimeExceptionHandler runtimeExceptionHandler) throws OWLRuntimeException {
        assert (ax != null);
        int initialSize = this.getConstraintSystem().leavesCount();
        Logging.getQueryLogger().fine("Initial size: ", (Object)initialSize);
        AbstractAxiomQuery query = this.getConstraintSystem().getReasoner() == null || !ax.isLogicalAxiom() ? new AssertedSolvabilityBasedAxiomQuery(this.getConstraintSystem().getOntologyManager(), this.getConstraintSystem(), runtimeExceptionHandler) : new InferredSolvabilityBasedTreeSearchAxiomQuery(this.getConstraintSystem(), runtimeExceptionHandler);
        Logging.getQueryTestLogging().fine("Used engine: ", (Object)query.getClass().getName());
        ax.accept((OWLAxiomVisitor)query);
        return OWLAPIStreamUtils.asSet(query.leaves());
    }

    @Override
    public void accept(QueryPlannerVisitor visitor) {
        visitor.visitInferredAxiomQueryPlannerItem(this);
    }

    @Override
    public <O> O accept(QueryPlannerVisitorEx<O> visitor) {
        return visitor.visitInferredAxiomQueryPlannerItem(this);
    }

    public String toString() {
        ManchesterSyntaxRenderer renderer = this.getConstraintSystem().getOPPLFactory().getManchesterSyntaxRenderer(this.getConstraintSystem());
        this.getAxiom().accept((OWLObjectVisitor)renderer);
        return String.format("INFERRED %s ", renderer.toString());
    }
}

