/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.queryplanner;

import java.util.Collection;
import java.util.Set;
import org.coode.oppl.AbstractConstraint;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.ExecutionMonitor;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.querymatching.ConstraintChecker;
import org.coode.oppl.queryplanner.AbstractQueryPlannerItem;
import org.coode.oppl.queryplanner.QueryPlannerVisitor;
import org.coode.oppl.queryplanner.QueryPlannerVisitorEx;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class ConstraintQueryPlannerItem
extends AbstractQueryPlannerItem {
    private final AbstractConstraint constraint;

    public ConstraintQueryPlannerItem(ConstraintSystem constraintSystem, AbstractConstraint constraint) {
        super(constraintSystem);
        this.constraint = ArgCheck.checkNotNull(constraint, "constraint");
    }

    @Override
    public Set<BindingNode> match(Collection<? extends BindingNode> currentLeaves, ExecutionMonitor executionMonitor, RuntimeExceptionHandler runtimeExceptionHandler) {
        Set toReturn = OWLAPIStreamUtils.asSet(currentLeaves.stream().filter(leaf -> !executionMonitor.isCancelled() && this.checkConstraint((BindingNode)leaf, this.getConstraint(), runtimeExceptionHandler) != false), BindingNode.class);
        if (executionMonitor.isCancelled()) {
            return null;
        }
        return toReturn;
    }

    private Boolean checkConstraint(BindingNode leaf, AbstractConstraint c, RuntimeExceptionHandler runtimeExceptionHandler) {
        SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(this.getConstraintSystem(), leaf, runtimeExceptionHandler);
        ConstraintChecker constraintChecker = new ConstraintChecker(parameters);
        return c.accept(constraintChecker);
    }

    @Override
    public void accept(QueryPlannerVisitor visitor) {
        visitor.visitConstraintQueryPlannerItem(this);
    }

    @Override
    public <O> O accept(QueryPlannerVisitorEx<O> visitor) {
        return visitor.visitConstraintQueryPlannerItem(this);
    }

    public AbstractConstraint getConstraint() {
        return this.constraint;
    }

    public String toString() {
        return this.getConstraint().render(this.getConstraintSystem());
    }
}

