/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.queryplanner;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.ExecutionMonitor;
import org.coode.oppl.PartialOWLObjectInstantiator;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.log.Logging;
import org.coode.oppl.querymatching.AssertedSolvabilityBasedAxiomQuery;
import org.coode.oppl.queryplanner.AbstractQueryPlannerItem;
import org.coode.oppl.queryplanner.QueryPlannerVisitor;
import org.coode.oppl.queryplanner.QueryPlannerVisitorEx;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class AssertedAxiomPlannerItem
extends AbstractQueryPlannerItem {
    private final OWLAxiom axiom;

    public AssertedAxiomPlannerItem(ConstraintSystem constraintSystem, OWLAxiom axiom) {
        super(constraintSystem);
        this.axiom = ArgCheck.checkNotNull(axiom, "axiom");
    }

    @Override
    public Set<BindingNode> match(Collection<? extends BindingNode> currentLeaves, ExecutionMonitor executionMonitor, RuntimeExceptionHandler runtimeExceptionHandler) {
        HashSet<BindingNode> toReturn = new HashSet<BindingNode>();
        if (currentLeaves != null) {
            Iterator<? extends BindingNode> iterator = currentLeaves.iterator();
            while (!executionMonitor.isCancelled() && iterator.hasNext()) {
                BindingNode bindingNode = iterator.next();
                SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(this.getConstraintSystem(), bindingNode, runtimeExceptionHandler);
                PartialOWLObjectInstantiator instantiator = new PartialOWLObjectInstantiator(parameters);
                OWLAxiom instantiatedAxiom = (OWLAxiom)this.getAxiom().accept((OWLObjectVisitorEx)instantiator);
                Set<BindingNode> newLeaves = this.updateBindingsAssertedAxiom(instantiatedAxiom, runtimeExceptionHandler);
                toReturn.addAll(this.merge(bindingNode, newLeaves));
            }
            if (executionMonitor.isCancelled()) {
                toReturn = null;
            }
        } else {
            toReturn.addAll(this.updateBindingsAssertedAxiom(this.getAxiom(), runtimeExceptionHandler));
        }
        return toReturn;
    }

    private Set<BindingNode> updateBindingsAssertedAxiom(OWLAxiom ax, RuntimeExceptionHandler runtimeExceptionHandler) {
        assert (ax != null);
        int initialSize = this.getConstraintSystem().leavesCount();
        Logging.getQueryLogger().log("Initial size: ", initialSize);
        AssertedSolvabilityBasedAxiomQuery query = new AssertedSolvabilityBasedAxiomQuery(this.getConstraintSystem().getOntologyManager(), this.getConstraintSystem(), runtimeExceptionHandler);
        ax.accept((OWLAxiomVisitor)query);
        return OWLAPIStreamUtils.asSet(query.leaves());
    }

    @Override
    public void accept(QueryPlannerVisitor visitor) {
        visitor.visitAssertedAxiomPlannerItem(this);
    }

    @Override
    public <O> O accept(QueryPlannerVisitorEx<O> visitor) {
        return visitor.visitAssertedAxiomPlannerItem(this);
    }

    public OWLAxiom getAxiom() {
        return this.axiom;
    }

    public String toString() {
        ManchesterSyntaxRenderer renderer = this.getConstraintSystem().getOPPLFactory().getManchesterSyntaxRenderer(this.getConstraintSystem());
        this.getAxiom().accept((OWLObjectVisitor)renderer);
        return String.format("ASSERTED %s ", renderer.toString());
    }
}

