/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.queryplanner;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.bindingtree.Assignment;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.queryplanner.QueryPlannerItem;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.model.OWLAxiom;

public abstract class AbstractQueryPlannerItem
implements QueryPlannerItem {
    private final ConstraintSystem constraintSystem;

    public AbstractQueryPlannerItem(ConstraintSystem constraintSystem) {
        this.constraintSystem = ArgCheck.checkNotNull(constraintSystem, "constraintSystem");
    }

    protected Set<BindingNode> merge(BindingNode leaf, Collection<? extends BindingNode> newLeaves) {
        HashSet<BindingNode> toReturn = new HashSet<BindingNode>();
        for (BindingNode bindingNode : newLeaves) {
            HashSet<Assignment> newAssignment = new HashSet<Assignment>(leaf.getAssignments());
            newAssignment.addAll(bindingNode.getAssignments());
            Stream newUnassigendVariables = Stream.concat(leaf.getUnassignedVariables().stream(), bindingNode.getUnassignedVariables().stream());
            toReturn.add(new BindingNode(newAssignment, newUnassigendVariables));
        }
        return toReturn;
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    protected boolean isVariableAxiom(OWLAxiom axiom) {
        return !this.getConstraintSystem().getAxiomVariables(axiom).isEmpty();
    }
}

