/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.querymatching;

import org.coode.oppl.ConstraintVisitorEx;
import org.coode.oppl.InCollectionConstraint;
import org.coode.oppl.InequalityConstraint;
import org.coode.oppl.NAFConstraint;
import org.coode.oppl.OWLObjectInstantiator;
import org.coode.oppl.RegExpConstraint;
import org.coode.oppl.Variable;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.log.Logging;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public class ConstraintChecker
implements ConstraintVisitorEx<Boolean> {
    private final ValueComputationParameters parameters;
    private final OWLObjectInstantiator instantiator;

    public ConstraintChecker(ValueComputationParameters parameters) {
        this.parameters = ArgCheck.checkNotNull(parameters, "parameters");
        this.instantiator = new OWLObjectInstantiator(this.getParameters());
    }

    public ValueComputationParameters getParameters() {
        return this.parameters;
    }

    @Override
    public Boolean visit(InequalityConstraint c) {
        OWLObject expression = c.getExpression();
        OWLObject instantiatedObject = (OWLObject)expression.accept((OWLObjectVisitorEx)this.instantiator);
        Variable<?> variable = c.getVariable();
        OWLObject assignedValue = this.getParameters().getBindingNode().getAssignmentValue(variable, this.getParameters());
        return !assignedValue.equals(instantiatedObject);
    }

    @Override
    public Boolean visit(InCollectionConstraint<? extends OWLObject> c) {
        OWLObject assignedValue = this.getParameters().getBindingNode().getAssignmentValue(c.getVariable(), this.getParameters());
        return c.collection().anyMatch(o -> assignedValue.equals(o.accept((OWLObjectVisitorEx)this.instantiator)));
    }

    @Override
    public Boolean visit(RegExpConstraint c) {
        return c.matches(this.getParameters());
    }

    @Override
    public Boolean visit(NAFConstraint nafConstraint) {
        OWLAxiom instantiatedAxiom = (OWLAxiom)nafConstraint.getAxiom().accept((OWLObjectVisitorEx)this.instantiator);
        boolean toReturn = false;
        try {
            boolean found;
            toReturn = this.getParameters().getConstraintSystem().getReasoner() != null && nafConstraint.getAxiom().isLogicalAxiom() ? !this.getParameters().getConstraintSystem().getReasoner().isEntailed(instantiatedAxiom) : !(found = this.getParameters().getConstraintSystem().getOntologyManager().ontologies().anyMatch(o -> o.containsAxiom(instantiatedAxiom)));
        }
        catch (OWLRuntimeException e) {
            Logging.getQueryLogger().log("OWLReasonerException caught whilst checking the constraint ", nafConstraint, this.getParameters().getConstraintSystem(), (Object)e);
        }
        return toReturn;
    }
}

