/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.querymatching;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.Variable;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.querymatching.AbstractAxiomQuery;
import org.coode.oppl.querymatching.AssertedSolvabilityBasedAxiomQuery;
import org.coode.oppl.search.OPPLAssertedSingleOWLAxiomSearchTree;
import org.coode.oppl.search.OPPLOWLAxiomSearchNode;
import org.coode.oppl.search.SearchTree;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.utils.OWLObjectExtractor;
import org.coode.oppl.utils.PositionBasedVariableComparator;
import org.coode.oppl.utils.VariableExtractor;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class AssertedTreeSearchSingleAxiomQuery
extends AbstractAxiomQuery {
    private final Map<OWLAxiom, SearchTree<OPPLOWLAxiomSearchNode>> searchTrees = new HashMap<OWLAxiom, SearchTree<OPPLOWLAxiomSearchNode>>();
    private final ConstraintSystem constraintSystem;
    private final Set<OWLOntology> ontologies = new HashSet<OWLOntology>();
    private final Map<BindingNode, Set<OWLAxiom>> instantiations = new HashMap<BindingNode, Set<OWLAxiom>>();
    private final Map<OWLAxiom, Collection<? extends OWLObject>> cache = new HashMap<OWLAxiom, Collection<? extends OWLObject>>();

    public AssertedTreeSearchSingleAxiomQuery(Stream<OWLOntology> ontologies, ConstraintSystem constraintSystem, RuntimeExceptionHandler runtimeExceptionHandler) {
        super(runtimeExceptionHandler);
        this.constraintSystem = ArgCheck.checkNotNull(constraintSystem, "constraintSystem");
        OWLAPIStreamUtils.add(this.ontologies, ArgCheck.checkNotNull(ontologies, "ontologies"));
    }

    @Override
    protected Set<BindingNode> match(OWLAxiom axiom) {
        this.clearInstantions();
        ArrayList<List<? extends OPPLOWLAxiomSearchNode>> solutions = new ArrayList<List<? extends OPPLOWLAxiomSearchNode>>();
        VariableExtractor variableExtractor = new VariableExtractor(this.getConstraintSystem(), false);
        Set<Variable<?>> extractedVariables = variableExtractor.extractVariables((OWLObject)axiom);
        TreeSet sortedVariables = new TreeSet(new PositionBasedVariableComparator((OWLObject)axiom, this.getConstraintSystem().getOntologyManager().getOWLDataFactory()));
        sortedVariables.addAll(extractedVariables);
        OPPLOWLAxiomSearchNode start = new OPPLOWLAxiomSearchNode(axiom, new BindingNode(sortedVariables));
        solutions.addAll(this.doMatch(start));
        return AssertedSolvabilityBasedAxiomQuery.extractLeaves(solutions);
    }

    private List<List<OPPLOWLAxiomSearchNode>> doMatch(OPPLOWLAxiomSearchNode start) {
        ArrayList<List<OPPLOWLAxiomSearchNode>> solutions = new ArrayList<List<OPPLOWLAxiomSearchNode>>();
        for (OWLOntology ontology : this.ontologies) {
            for (OWLAxiom oWLAxiom : this.filterAxioms(start.getAxiom(), ontology.axioms())) {
                if (!start.getAxiom().getAxiomType().equals((Object)oWLAxiom.getAxiomType())) continue;
                solutions.addAll(this.matchTargetAxiom(start, oWLAxiom));
            }
        }
        return solutions;
    }

    private List<List<OPPLOWLAxiomSearchNode>> matchTargetAxiom(OPPLOWLAxiomSearchNode start, OWLAxiom targetAxiom) {
        SearchTree<OPPLOWLAxiomSearchNode> searchTree = this.getSearchTree(targetAxiom);
        ArrayList<List<OPPLOWLAxiomSearchNode>> solutions = new ArrayList<List<OPPLOWLAxiomSearchNode>>();
        searchTree.exhaustiveSearchTree(start, solutions);
        return solutions;
    }

    private SearchTree<OPPLOWLAxiomSearchNode> getSearchTree(OWLAxiom targetAxiom) {
        OPPLAssertedSingleOWLAxiomSearchTree toReturn = this.searchTrees.get(targetAxiom);
        if (toReturn == null) {
            toReturn = new OPPLAssertedSingleOWLAxiomSearchTree(targetAxiom, this.getConstraintSystem(), this.getRuntimeExceptionHandler());
            this.searchTrees.put(targetAxiom, toReturn);
        }
        return toReturn;
    }

    private void clearInstantions() {
        this.instantiations.clear();
    }

    public Map<BindingNode, Set<OWLAxiom>> getInstantiations() {
        return new HashMap<BindingNode, Set<OWLAxiom>>(this.instantiations);
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    private Collection<? extends OWLAxiom> filterAxioms(OWLAxiom toMatchAxiom, Stream<? extends OWLAxiom> axioms) {
        HashSet toReturn = new HashSet();
        VariableExtractor variableExtractor = new VariableExtractor(this.getConstraintSystem(), true);
        Set<Variable<?>> variables = variableExtractor.extractVariables((OWLObject)toMatchAxiom);
        Collection<? extends OWLObject> toMatchAllOWLObjects = this.extractOWLObjects(toMatchAxiom);
        axioms.forEach(candidate -> this.filterAxiom(toMatchAxiom, toReturn, variables, toMatchAllOWLObjects, (OWLAxiom)candidate));
        return toReturn;
    }

    protected void filterAxiom(OWLAxiom toMatchAxiom, Set<OWLAxiom> toReturn, Set<Variable<?>> variables, Collection<? extends OWLObject> toMatchAllOWLObjects, OWLAxiom candidate) {
        Collection<? extends OWLObject> candidateAllOWLObjects = this.extractOWLObjects(candidate);
        if (candidate.getAxiomType().equals((Object)toMatchAxiom.getAxiomType()) && toMatchAllOWLObjects.containsAll(candidateAllOWLObjects)) {
            toReturn.add(candidate);
        } else {
            HashSet<? extends OWLObject> difference = new HashSet<OWLObject>(candidateAllOWLObjects);
            difference.removeAll(toMatchAllOWLObjects);
            Iterator iterator = difference.iterator();
            boolean found = false;
            while (!found && iterator.hasNext()) {
                OWLObject leftOutOWLObject = (OWLObject)iterator.next();
                Iterator<Variable<?>> variableIterator = variables.iterator();
                boolean compatible = false;
                while (!compatible && variableIterator.hasNext()) {
                    Variable<?> variable = variableIterator.next();
                    compatible = variable.getType().isCompatibleWith(leftOutOWLObject);
                }
                found = !compatible;
            }
            if (!found) {
                toReturn.add(candidate);
            }
        }
    }

    private Collection<? extends OWLObject> extractOWLObjects(OWLAxiom axiom) {
        return this.cache.computeIfAbsent(axiom, ax -> OWLAPIStreamUtils.asList(OWLObjectExtractor.getAllOWLPrimitives((OWLObject)ax)));
    }
}

