/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.querymatching;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.PartialOWLObjectInstantiator;
import org.coode.oppl.Variable;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.querymatching.AbstractAxiomQuery;
import org.coode.oppl.search.OPPLAssertedOWLAxiomSearchTree;
import org.coode.oppl.search.OPPLOWLAxiomSearchNode;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.utils.PositionBasedVariableComparator;
import org.coode.oppl.utils.VariableExtractor;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;

public class AssertedTreeSearchAxiomQuery
extends AbstractAxiomQuery {
    private final ConstraintSystem constraintSystem;
    private final Set<OWLOntology> ontologies = new HashSet<OWLOntology>();
    private final Map<BindingNode, Set<OWLAxiom>> instantiations = new HashMap<BindingNode, Set<OWLAxiom>>();

    public AssertedTreeSearchAxiomQuery(Set<OWLOntology> ontologies, ConstraintSystem constraintSystem, RuntimeExceptionHandler runtimeExceptionHandler) {
        super(runtimeExceptionHandler);
        this.constraintSystem = ArgCheck.checkNotNull(constraintSystem, "constraintSystem");
        this.ontologies.addAll((Collection<OWLOntology>)ArgCheck.checkNotNull(ontologies, "ontologies"));
    }

    @Override
    protected Set<BindingNode> match(OWLAxiom axiom) {
        this.clearInstantions();
        OPPLAssertedOWLAxiomSearchTree searchTree = new OPPLAssertedOWLAxiomSearchTree(this.getConstraintSystem(), this.getRuntimeExceptionHandler());
        VariableExtractor variableExtractor = new VariableExtractor(this.getConstraintSystem(), false);
        Set<Variable<?>> extractedVariables = variableExtractor.extractVariables((OWLObject)axiom);
        TreeSet sortedVariables = new TreeSet(new PositionBasedVariableComparator((OWLObject)axiom, this.getConstraintSystem().getOntologyManager().getOWLDataFactory()));
        sortedVariables.addAll(extractedVariables);
        ArrayList<List<OPPLOWLAxiomSearchNode>> solutions = new ArrayList<List<OPPLOWLAxiomSearchNode>>();
        searchTree.exhaustiveSearchTree(new OPPLOWLAxiomSearchNode(axiom, new BindingNode(sortedVariables)), (List<List<OPPLOWLAxiomSearchNode>>)solutions);
        for (List list : solutions) {
            OPPLOWLAxiomSearchNode searchLeaf = (OPPLOWLAxiomSearchNode)list.get(list.size() - 1);
            BindingNode leaf = searchLeaf.getBinding();
            SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(this.getConstraintSystem(), leaf, this.getRuntimeExceptionHandler());
            PartialOWLObjectInstantiator partialOWLObjectInstantiator = new PartialOWLObjectInstantiator(parameters);
            this.instantiations.computeIfAbsent(leaf, x -> new HashSet()).add((OWLAxiom)axiom.accept((OWLObjectVisitorEx)partialOWLObjectInstantiator));
        }
        return new HashSet<BindingNode>(this.instantiations.keySet());
    }

    private void clearInstantions() {
        this.instantiations.clear();
    }

    public Map<BindingNode, Set<OWLAxiom>> getInstantiations() {
        return new HashMap<BindingNode, Set<OWLAxiom>>(this.instantiations);
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    public Set<OWLOntology> getOntologies() {
        return new HashSet<OWLOntology>(this.ontologies);
    }
}

