/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.log;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.LogManager;
import org.coode.oppl.log.Logger;

public class Logging {
    private static final String LOG_FILE_PRPERTY_NAME = "org.coode.oppl.log.Logging.FileName";
    private static final Logger profiling;
    private static final Logger main;
    private static final Logger query;
    private static final Logger queryTest;
    private static final Logger parseTest;
    private static final Logger parse;

    public static final Logger getProfilingLogger() {
        return profiling;
    }

    public static final Logger getMainLogger() {
        return main;
    }

    public static final Logger getQueryLogger() {
        return query;
    }

    public static final Logger getQueryTestLogging() {
        return queryTest;
    }

    public static final Logger getParseTestLogging() {
        return parseTest;
    }

    public static final Logger getParseLogging() {
        return parse;
    }

    static {
        try {
            InputStream in;
            String logFileName = System.getProperty(LOG_FILE_PRPERTY_NAME);
            InputStream inputStream = in = logFileName == null ? null : Logging.class.getClassLoader().getResourceAsStream(logFileName);
            if (in == null) {
                in = Logging.class.getResourceAsStream("/oppl-logging.properties");
            }
            if (in != null) {
                LogManager.getLogManager().readConfiguration(in);
                in.close();
            }
        }
        catch (IOException | SecurityException e) {
            System.out.println("No local log configuration file found");
        }
        profiling = new Logger("org.coode.oppl.profiling");
        main = new Logger("org.coode.oppl");
        query = new Logger("org.coode.oppl.query");
        queryTest = new Logger("org.coode.oppl.query.test");
        parseTest = new Logger("org.coode.oppl.test");
        parse = new Logger("org.coode.oppl.test");
    }
}

