/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.function;

import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.Variable;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.AttributeName;
import org.coode.oppl.function.OPPLFunction;
import org.coode.oppl.function.OPPLFunctionVisitor;
import org.coode.oppl.function.OPPLFunctionVisitorEx;
import org.coode.oppl.function.ValueComputation;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.function.VariableAttribute;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;

public class IRIVariableAttribute
extends VariableAttribute<IRI> {
    public IRIVariableAttribute(Variable<?> variable) {
        super(variable, AttributeName.IRI);
    }

    @Override
    public <P> P accept(OPPLFunctionVisitorEx<P> visitor) {
        return visitor.visitIRIVariableAttribute(this);
    }

    @Override
    public void accept(OPPLFunctionVisitor visitor) {
        visitor.visitIRIVariableAttribute(this);
    }

    @Override
    public ValueComputation<IRI> getValueComputation(ValueComputationParameters parameters) {
        return opplFunction -> {
            IRI toReturn = null;
            BindingNode bindingNode = parameters.getBindingNode();
            OWLObject assignmentValue = bindingNode.getAssignmentValue(this.getVariable(), parameters);
            if (assignmentValue != null) {
                toReturn = (IRI)assignmentValue.accept((OWLObjectVisitorEx)new OWLObjectVisitorEx<IRI>(){

                    public <T> IRI doDefault(T object) {
                        return null;
                    }

                    public IRI visit(OWLAnnotationProperty property) {
                        return this.getOWLEntityIRI((OWLEntity)property);
                    }

                    public IRI visit(OWLClass desc) {
                        return this.getOWLEntityIRI((OWLEntity)desc);
                    }

                    public IRI visit(OWLDatatype node) {
                        return this.getOWLEntityIRI((OWLEntity)node);
                    }

                    public IRI visit(OWLObjectProperty property) {
                        return this.getOWLEntityIRI((OWLEntity)property);
                    }

                    public IRI visit(OWLNamedIndividual individual) {
                        return this.getOWLEntityIRI((OWLEntity)individual);
                    }

                    private IRI getOWLEntityIRI(OWLEntity entity) {
                        return entity.getIRI();
                    }
                });
            }
            return toReturn;
        };
    }

    public OPPLFunction<IRI> replace(Variable<?> v, OWLObject owlObject, ConstraintSystem constraintSystem, RuntimeExceptionHandler handler) {
        return this;
    }
}

