/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.function;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.function.Aggregandum;
import org.coode.oppl.function.Aggregation;
import org.coode.oppl.function.ValueComputationParameters;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.ShortFormProvider;

class ClassUnionAggregation
extends Aggregation<OWLClassExpression, Collection<OWLClassExpression>> {
    private final OWLDataFactory dataFactory;

    ClassUnionAggregation(Collection<Aggregandum<Collection<OWLClassExpression>>> toAggregate, OWLDataFactory dataFactory) {
        super(toAggregate);
        this.dataFactory = dataFactory;
    }

    @Override
    protected OWLClassExpression aggregate(ValueComputationParameters parameters) {
        List operands = OWLAPIStreamUtils.asList(this.toAggregate.stream().flatMap(Aggregandum::opplFunctions).map(f -> (Collection)f.compute(parameters)).filter(Objects::nonNull).flatMap(Collection::stream));
        return operands.isEmpty() ? null : this.dataFactory.getOWLObjectUnionOf((Collection)operands);
    }

    @Override
    public String render(ConstraintSystem constraintSystem) {
        return this.renderAggregation(constraintSystem, "createUnion", "(", ", ", ")");
    }

    @Override
    public String render(ShortFormProvider shortFormProvider) {
        return this.renderAggregation(shortFormProvider, "createUnion", "(", ", ", ")");
    }
}

