/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.function.AbstractOPPLFunction;
import org.coode.oppl.function.Aggregandum;
import org.coode.oppl.function.ClassIntersectionAggregation;
import org.coode.oppl.function.ClassUnionAggregation;
import org.coode.oppl.function.OPPLFunction;
import org.coode.oppl.function.OPPLFunctionVisitor;
import org.coode.oppl.function.OPPLFunctionVisitorEx;
import org.coode.oppl.function.StringConcatAggregation;
import org.coode.oppl.function.ValueComputation;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.util.ShortFormProvider;

public abstract class Aggregation<O, I>
extends AbstractOPPLFunction<O>
implements OPPLFunction<O> {
    protected final List<Aggregandum<I>> toAggregate = new ArrayList<Aggregandum<I>>();

    public Aggregation(Collection<? extends Aggregandum<I>> toAggregate) {
        this.toAggregate.addAll(ArgCheck.checkNotNull(toAggregate, "toAggregate"));
        if (toAggregate.isEmpty()) {
            throw new IllegalArgumentException("The collection of elements to aggregate cannot be null");
        }
    }

    protected abstract O aggregate(ValueComputationParameters var1);

    @Deprecated
    public List<Aggregandum<I>> getToAggregate() {
        return new ArrayList<Aggregandum<I>>(this.toAggregate);
    }

    public Stream<Aggregandum<I>> toAggregate() {
        return this.toAggregate.stream();
    }

    @Override
    public <P> P accept(OPPLFunctionVisitorEx<P> visitor) {
        return visitor.visitAggregation(this);
    }

    @Override
    public void accept(OPPLFunctionVisitor visitor) {
        visitor.visitAggregation(this);
    }

    @Override
    public ValueComputation<O> getValueComputation(ValueComputationParameters parameters) {
        return opplFunction -> this.aggregate(parameters);
    }

    public static Aggregation<String, String> buildStringConcatenation(Collection<? extends Aggregandum<String>> a) {
        return new StringConcatAggregation(a);
    }

    public static Aggregation<OWLClassExpression, Collection<OWLClassExpression>> buildClassExpressionIntersection(Collection<Aggregandum<Collection<OWLClassExpression>>> a, OWLDataFactory dataFactory) {
        return new ClassIntersectionAggregation(a, dataFactory);
    }

    public static Aggregation<OWLClassExpression, Collection<OWLClassExpression>> buildClassExpressionUnion(Collection<Aggregandum<Collection<OWLClassExpression>>> a, OWLDataFactory dataFactory) {
        return new ClassUnionAggregation(a, dataFactory);
    }

    protected String renderAggregation(ConstraintSystem constraintSystem, String prefix, String openDelimiter, String separator, String closedDelimiter) {
        return this.toAggregate.stream().flatMap(Aggregandum::opplFunctions).map(f -> f.render(constraintSystem)).collect(Collectors.joining(separator, prefix + openDelimiter, closedDelimiter));
    }

    protected String renderAggregation(ShortFormProvider shortFormProvider, String prefix, String openDelimiter, String separator, String closedDelimiter) {
        return this.toAggregate.stream().flatMap(Aggregandum::opplFunctions).map(f -> f.render(shortFormProvider)).collect(Collectors.joining(separator, prefix + openDelimiter, closedDelimiter));
    }
}

