/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl;

import org.coode.oppl.ClassVariableScope;
import org.coode.oppl.IndividualVariableScope;
import org.coode.oppl.PropertyVariableScope;
import org.coode.oppl.SubClassVariableScope;
import org.coode.oppl.SubPropertyVariableScope;
import org.coode.oppl.SuperClassVariableScope;
import org.coode.oppl.SuperPropertyVariableScope;
import org.coode.oppl.VariableScopeChecker;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLPropertyExpression;

public class VariableScopes {
    public static SubClassVariableScope buildSubClassVariableScope(OWLClassExpression description, VariableScopeChecker checker) {
        return ClassVariableScope.buildSubClassVariableScope(description, checker);
    }

    public static SuperClassVariableScope buildSuperClassVariableScope(OWLClassExpression description, VariableScopeChecker checker) {
        return ClassVariableScope.buildSuperClassVariableScope(description, checker);
    }

    public static SubPropertyVariableScope<OWLDataProperty> buildSubPropertyVariableScope(OWLDataProperty property, VariableScopeChecker checker) {
        return PropertyVariableScope.buildSubPropertyVariableScope(property, checker);
    }

    public static <P extends OWLPropertyExpression> SubPropertyVariableScope<P> buildSubPropertyVariableScope(P property, VariableScopeChecker checker) {
        return PropertyVariableScope.buildSubPropertyVariableScope(property, checker);
    }

    public static <P extends OWLPropertyExpression> SuperPropertyVariableScope<P> buildSuperPropertyVariableScope(P property, VariableScopeChecker checker) {
        return PropertyVariableScope.buildSuperPropertyVariableScope(property, checker);
    }

    public static IndividualVariableScope buildIndividualVariableScope(OWLClassExpression description, VariableScopeChecker checker) {
        return IndividualVariableScope.buildIndividualVariableScope(description, checker);
    }

    public static enum Direction {
        SUBCLASSOF("subClassOf"),
        SUPERCLASSOF("superClassOf"),
        SUBPROPERTYOF("subPropertyOf"),
        SUPERPROPERTYOF("superPropertyOf"),
        INSTANCEOF("instanceOf");

        private final String direction;

        private Direction(String s) {
            this.direction = s;
        }

        public static Direction getDirection(String direction) {
            for (Direction d : Direction.values()) {
                if (!direction.equalsIgnoreCase(d.direction)) continue;
                return d;
            }
            return null;
        }

        public String toString() {
            return this.direction;
        }
    }
}

