/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl;

import org.coode.oppl.AbstractVariableScope;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.SubPropertyVariableScope;
import org.coode.oppl.SuperPropertyVariableScope;
import org.coode.oppl.VariableScope;
import org.coode.oppl.VariableScopeChecker;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLPropertyExpression;

public abstract class PropertyVariableScope<P extends OWLPropertyExpression>
extends AbstractVariableScope<P>
implements VariableScope<P> {
    private final P property;

    PropertyVariableScope(P property, VariableScopeChecker checker) {
        super(checker);
        this.property = property;
    }

    public P getProperty() {
        return this.property;
    }

    static <O extends OWLPropertyExpression> SubPropertyVariableScope<O> buildSubPropertyVariableScope(O property, VariableScopeChecker checker) {
        return new SubPropertyVariableScope<O>(property, checker);
    }

    static <O extends OWLPropertyExpression> SuperPropertyVariableScope<O> buildSuperPropertyVariableScope(O property, VariableScopeChecker checker) {
        return new SuperPropertyVariableScope<O>(property, checker);
    }

    @Override
    public P getScopingObject() {
        return this.getProperty();
    }

    @Override
    public String render(ConstraintSystem constraintSystem) {
        ManchesterSyntaxRenderer renderer = constraintSystem.getOPPLFactory().getManchesterSyntaxRenderer(constraintSystem);
        this.getScopingObject().accept((OWLObjectVisitor)renderer);
        return String.format("[%s %s]", new Object[]{this.getDirection(), renderer});
    }
}

