/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl;

import java.util.ArrayList;
import java.util.List;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.OPPLAbstractFactory;
import org.coode.oppl.OPPLQuery;
import org.coode.oppl.OPPLQueryImpl;
import org.coode.oppl.OPPLScript;
import org.coode.oppl.OPPLScriptVisitor;
import org.coode.oppl.OPPLScriptVisitorEx;
import org.coode.oppl.Variable;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.coode.oppl.utils.VariableRecogniser;
import org.coode.oppl.variabletypes.InputVariable;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class OPPLScriptImpl
implements OPPLScript {
    private final ConstraintSystem constraintSystem;
    private final List<Variable<?>> variables = new ArrayList();
    private final OPPLQuery query;
    private final List<OWLAxiomChange> actions;
    private final OPPLAbstractFactory factory;

    public OPPLScriptImpl(ConstraintSystem constraintSystem, List<Variable<?>> variables, OPPLQuery query, List<OWLAxiomChange> actions, OPPLAbstractFactory factory) {
        this(constraintSystem, variables, query, actions, factory, false);
    }

    public OPPLScriptImpl(ConstraintSystem constraintSystem, List<Variable<?>> variables, OPPLQuery query, List<OWLAxiomChange> actions, OPPLAbstractFactory factory, boolean resetExecution) {
        this.constraintSystem = constraintSystem;
        this.variables.addAll(variables);
        this.query = !resetExecution ? query : (query == null ? null : new OPPLQueryImpl(query, factory));
        this.actions = new ArrayList<OWLAxiomChange>(actions);
        this.factory = factory;
    }

    @Override
    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    @Override
    public List<InputVariable<?>> getInputVariables() {
        ArrayList toReturn = new ArrayList(this.variables.size());
        for (Variable<?> v : this.variables) {
            if (!VariableRecogniser.INPUT_VARIABLE_RECOGNISER.recognise(v)) continue;
            toReturn.add((InputVariable)v);
        }
        return toReturn;
    }

    @Override
    public List<Variable<?>> getVariables() {
        return new ArrayList(this.variables);
    }

    @Override
    public OPPLQuery getQuery() {
        return this.query;
    }

    @Override
    public List<OWLAxiomChange> getActions() {
        return this.actions;
    }

    @Override
    public void accept(OPPLScriptVisitor visitor) {
        for (Variable<?> v : this.variables) {
            visitor.visit(v);
        }
        visitor.visit(this.getQuery());
        visitor.visitActions(this.getActions());
    }

    @Override
    public <P> P accept(OPPLScriptVisitorEx<P> visitor) {
        P p = null;
        for (Variable<?> v : this.variables) {
            p = visitor.visit(v, p);
        }
        p = visitor.visit(this.getQuery(), p);
        p = visitor.visitActions(this.getActions(), p);
        return p;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (Variable<?> v : this.variables) {
            String commaString = first ? "" : ", ";
            first = false;
            buffer.append(commaString);
            buffer.append(v.render(this.getConstraintSystem()));
        }
        if (buffer.length() > 0) {
            buffer.append(" ");
        }
        OPPLQuery opplQuery = this.getQuery();
        if (this.query != null) {
            buffer.append(opplQuery.toString());
        }
        if (!this.getActions().isEmpty()) {
            buffer.append(" BEGIN ");
            first = true;
            for (OWLAxiomChange action : this.getActions()) {
                String commaString = first ? "" : ", ";
                ManchesterSyntaxRenderer renderer = this.factory.getManchesterSyntaxRenderer(this.constraintSystem);
                String actionString = action.isAddAxiom() ? "ADD " : "REMOVE ";
                first = false;
                buffer.append(commaString);
                buffer.append(actionString);
                action.getAxiom().accept((OWLObjectVisitor)renderer);
                buffer.append(renderer.toString());
            }
            buffer.append(" END;");
        }
        return buffer.toString();
    }

    @Override
    public String render() {
        return this.toString();
    }

    @Override
    public String render(ConstraintSystem cs) {
        return this.render();
    }

    @Override
    public String render(ShortFormProvider shortFormProvider) {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (Variable<?> v : this.variables) {
            String commaString = first ? "" : ", ";
            first = false;
            buffer.append(commaString);
            buffer.append(v.render(this.getConstraintSystem()));
        }
        if (buffer.length() > 0) {
            buffer.append(" ");
        }
        OPPLQuery opplQuery = this.getQuery();
        if (this.query != null) {
            buffer.append(opplQuery.render(shortFormProvider));
        }
        if (!this.getActions().isEmpty()) {
            buffer.append(" BEGIN ");
            first = true;
            for (OWLAxiomChange action : this.getActions()) {
                String commaString = first ? "" : ", ";
                ManchesterSyntaxRenderer renderer = new ManchesterSyntaxRenderer(shortFormProvider);
                String actionString = action.isAddAxiom() ? "ADD " : "REMOVE ";
                first = false;
                buffer.append(commaString);
                buffer.append(actionString);
                action.getAxiom().accept((OWLObjectVisitor)renderer);
                buffer.append(renderer.toString());
            }
            buffer.append(" END;");
        }
        return buffer.toString();
    }

    @Override
    public void addVariable(Variable<?> variable) {
        this.variables.add(variable);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
        result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
        result = 31 * result + (this.variables == null ? 0 : this.variables.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OPPLScriptImpl other = (OPPLScriptImpl)obj;
        if (this.actions == null ? other.actions != null : !this.actions.equals(other.actions)) {
            return false;
        }
        if (this.query == null ? other.query != null : !this.query.equals(other.query)) {
            return false;
        }
        return !(this.variables == null ? other.variables != null : !this.variables.equals(other.variables));
    }
}

