/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.EntityFactory;
import org.coode.oppl.OPPLAbstractFactory;
import org.coode.oppl.OPPLQuery;
import org.coode.oppl.OPPLQueryImpl;
import org.coode.oppl.OPPLScript;
import org.coode.oppl.OPPLScriptImpl;
import org.coode.oppl.OPPLShortFormProvider;
import org.coode.oppl.Variable;
import org.coode.oppl.VariableScopeChecker;
import org.coode.oppl.entity.OWLEntityFactory;
import org.coode.oppl.entity.OWLEntityRenderer;
import org.coode.oppl.entity.OWLEntityRendererImpl;
import org.coode.oppl.exceptions.NullReasonerException;
import org.coode.oppl.exceptions.OPPLException;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.coode.oppl.rendering.VariableOWLEntityRenderer;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.expression.OWLEntityChecker;
import org.semanticweb.owlapi.expression.ShortFormEntityChecker;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.BidirectionalShortFormProvider;
import org.semanticweb.owlapi.util.BidirectionalShortFormProviderAdapter;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;

public class OPPLFactory
implements OPPLAbstractFactory {
    private final OWLOntologyManager ontologyManager;
    private VariableScopeChecker variableScopeChecker = null;
    private final OWLReasoner reasoner;
    private final OWLOntology ontology;
    private OWLEntityChecker entityChecker = null;
    public static final IRI DEFAULT_ONTOLOGY_IRI = IRI.create((String)"http://www.coode.org/oppl");

    public OPPLFactory(OWLOntologyManager ontologyManager, OWLOntology ontology, OWLReasoner reasoner) {
        this.ontologyManager = ontologyManager;
        this.ontology = ontology;
        this.reasoner = reasoner;
        this.entityChecker = this.defaultEntityChecker();
    }

    private OWLEntityChecker defaultEntityChecker() {
        BidirectionalShortFormProviderAdapter bshp = new BidirectionalShortFormProviderAdapter((Collection)OWLAPIStreamUtils.asList((Stream)this.ontologyManager.ontologies()), (ShortFormProvider)new OPPLShortFormProvider((ShortFormProvider)new SimpleShortFormProvider()));
        bshp.add((OWLEntity)this.ontologyManager.getOWLDataFactory().getOWLThing());
        bshp.add((OWLEntity)this.ontologyManager.getOWLDataFactory().getOWLNothing());
        return new ShortFormEntityChecker((BidirectionalShortFormProvider)bshp);
    }

    @Override
    public OWLEntityChecker getOWLEntityChecker() {
        return this.entityChecker;
    }

    @Override
    public VariableScopeChecker getVariableScopeChecker() throws OPPLException {
        if (this.reasoner == null) {
            throw new NullReasonerException();
        }
        this.variableScopeChecker = this.variableScopeChecker != null ? this.variableScopeChecker : new VariableScopeChecker(this.ontologyManager, this.reasoner);
        return this.variableScopeChecker;
    }

    @Override
    public OWLEntityRenderer getOWLEntityRenderer(ConstraintSystem cs) {
        return new VariableOWLEntityRenderer(ArgCheck.checkNotNull(cs, "constraint system"), new OWLEntityRendererImpl());
    }

    @Override
    public OWLEntityFactory getOWLEntityFactory() {
        return new EntityFactory(this);
    }

    @Override
    public OPPLScript buildOPPLScript(ConstraintSystem constraintSystem1, List<Variable<?>> variables, OPPLQuery opplQuery, List<OWLAxiomChange> actions) {
        if (variables == null || variables.contains(null)) {
            throw new IllegalArgumentException("Invalid variables");
        }
        if (actions == null || actions.contains(null)) {
            throw new IllegalArgumentException("Invalid actions");
        }
        return new OPPLScriptImpl(constraintSystem1, variables, opplQuery, actions, this);
    }

    @Override
    public OPPLQuery buildNewQuery(ConstraintSystem constraintSystem1) {
        return new OPPLQueryImpl(constraintSystem1, (OPPLAbstractFactory)this);
    }

    @Override
    public ConstraintSystem createConstraintSystem() {
        return this.reasoner == null ? new ConstraintSystem(this.ontology, this.ontologyManager, this) : new ConstraintSystem(this.ontology, this.ontologyManager, this.reasoner, this);
    }

    @Override
    public OWLDataFactory getOWLDataFactory() {
        return this.ontologyManager.getOWLDataFactory();
    }

    @Override
    public ManchesterSyntaxRenderer getManchesterSyntaxRenderer(ConstraintSystem cs) {
        return new ManchesterSyntaxRenderer(new OPPLShortFormProvider((ShortFormProvider)new SimpleShortFormProvider()));
    }

    @Override
    public OWLOntologyManager getOntologyManager() {
        return this.ontologyManager;
    }

    @Override
    public OPPLScript importOPPLScript(OPPLScript opplScript) {
        ConstraintSystem newConstraintSystem = this.createConstraintSystem();
        for (Variable<?> variable : opplScript.getConstraintSystem().getVariables()) {
            newConstraintSystem.importVariable(variable);
        }
        return new OPPLScriptImpl(newConstraintSystem, opplScript.getVariables(), opplScript.getQuery(), opplScript.getActions(), this, true);
    }

    @Override
    public OWLOntology getOntology() {
        return this.ontology;
    }

    @Override
    public IRI getDefaultOntologyIRI() {
        return DEFAULT_ONTOLOGY_IRI;
    }
}

