/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.coode.oppl.AbstractConstraint;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.ConstraintVisitor;
import org.coode.oppl.ConstraintVisitorEx;
import org.coode.oppl.Variable;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class InCollectionConstraint<P extends OWLObject>
implements AbstractConstraint {
    private final Variable<P> variable;
    private final Set<P> collection = new HashSet<P>();
    private final ConstraintSystem constraintSystem;

    public InCollectionConstraint(Variable<P> variable, Collection<? extends P> collection, ConstraintSystem constraintSystem) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("The collection of values cannot be empty");
        }
        this.variable = ArgCheck.checkNotNull(variable, "variable");
        this.collection.addAll(ArgCheck.checkNotNull(collection, "collection"));
        this.constraintSystem = ArgCheck.checkNotNull(constraintSystem, "constraintSystem");
        for (OWLObject p : collection) {
            if (variable.getType().isCompatibleWith(p)) continue;
            ManchesterSyntaxRenderer manchesterSyntaxRenderer = constraintSystem.getOPPLFactory().getManchesterSyntaxRenderer(constraintSystem);
            p.accept((OWLObjectVisitor)manchesterSyntaxRenderer);
            throw new IllegalArgumentException(String.format("The value %s is incompatible with variable %s of type %s", manchesterSyntaxRenderer, variable, variable.getType()));
        }
    }

    @Override
    public <O> O accept(ConstraintVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    public Variable<P> getVariable() {
        return this.variable;
    }

    @Deprecated
    public Set<P> getCollection() {
        return new HashSet<P>(this.collection);
    }

    public Stream<P> collection() {
        return this.collection.stream();
    }

    public int hashCode() {
        return 3 * this.variable.hashCode() * 5 * this.collection.hashCode();
    }

    public boolean equals(Object obj) {
        boolean toReturn = false;
        if (obj instanceof InCollectionConstraint) {
            InCollectionConstraint toCompare = (InCollectionConstraint)obj;
            toReturn = this.getVariable().equals(toCompare.variable) && this.collection.equals(toCompare.collection);
        }
        return toReturn;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.variable.getName());
        buffer.append(" IN {");
        boolean first = true;
        for (OWLObject p : this.collection) {
            ManchesterSyntaxRenderer manchesterSyntaxRenderer = this.getConstraintSystem().getOPPLFactory().getManchesterSyntaxRenderer(this.getConstraintSystem());
            String comma = !first ? ", " : "";
            first = false;
            buffer.append(comma);
            p.accept((OWLObjectVisitor)manchesterSyntaxRenderer);
            buffer.append(manchesterSyntaxRenderer.toString());
        }
        buffer.append('}');
        return buffer.toString();
    }

    @Override
    public String render(ShortFormProvider shortFormProvider) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.variable.getName());
        buffer.append(" IN {");
        boolean first = true;
        for (OWLObject p : this.collection) {
            String comma = !first ? ", " : "";
            first = false;
            buffer.append(comma);
            ManchesterSyntaxRenderer renderer = new ManchesterSyntaxRenderer(shortFormProvider);
            p.accept((OWLObjectVisitor)renderer);
            buffer.append(renderer.toString());
        }
        buffer.append('}');
        return buffer.toString();
    }

    @Override
    public String render(ConstraintSystem cs) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.variable.getName());
        buffer.append(" IN {");
        boolean first = true;
        for (OWLObject p : this.collection) {
            String comma = !first ? ", " : "";
            first = false;
            buffer.append(comma);
            ManchesterSyntaxRenderer renderer = cs.getOPPLFactory().getManchesterSyntaxRenderer(this.getConstraintSystem());
            p.accept((OWLObjectVisitor)renderer);
            buffer.append(renderer.toString());
        }
        buffer.append('}');
        return buffer.toString();
    }

    @Override
    public void accept(ConstraintVisitor visitor) {
        visitor.visitInCollectionConstraint(this);
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    public static <T extends OWLObject> InCollectionConstraint<T> getInCollectionConstraint(Variable<T> variable, Collection<? extends T> collection, ConstraintSystem constraintSystem) {
        return new InCollectionConstraint<T>(variable, collection, constraintSystem);
    }
}

