/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl;

import java.util.HashSet;
import java.util.stream.Stream;
import org.coode.oppl.ActionType;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.PartialOWLObjectInstantiator;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class ActionFactory {
    public static Stream<OWLAxiomChange> createChanges(ActionType actionType, OWLAxiom axiom, ConstraintSystem cs, OWLOntology ontology, RuntimeExceptionHandler runtimeExcpetionHandler) {
        HashSet<Object> toReturn = new HashSet<Object>();
        if (cs.leavesCount() > 0) {
            cs.leaves().forEach(bindingNode -> {
                SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(cs, (BindingNode)bindingNode, runtimeExcpetionHandler);
                PartialOWLObjectInstantiator instatiator = new PartialOWLObjectInstantiator(parameters);
                OWLAxiom instantiatedAxiom = (OWLAxiom)axiom.accept((OWLObjectVisitorEx)instatiator);
                switch (actionType) {
                    case ADD: {
                        toReturn.add(new AddAxiom(ontology, instantiatedAxiom));
                        break;
                    }
                    case REMOVE: {
                        toReturn.add(new RemoveAxiom(ontology, instantiatedAxiom));
                        break;
                    }
                }
            });
        } else if (cs.getAxiomVariables(axiom).isEmpty()) {
            switch (actionType) {
                case ADD: {
                    toReturn.add(new AddAxiom(ontology, axiom));
                    break;
                }
                case REMOVE: {
                    toReturn.add(new RemoveAxiom(ontology, axiom));
                    break;
                }
            }
        }
        return toReturn.stream();
    }

    public static Stream<OWLAxiomChange> createChanges(ActionType actionType, OWLAxiom axiom, ConstraintSystem cs, Stream<OWLOntology> ontologies, RuntimeExceptionHandler runtimeExceptionHandler) {
        return ontologies.flatMap(o -> ActionFactory.createChanges(actionType, axiom, cs, o, runtimeExceptionHandler));
    }
}

