package org.coode.parsers.ui.autocompletionmatcher;

import java.util.ArrayList;
import java.util.List;

import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;
import org.coode.parsers.*;

/**
 * Decides matches based on the parse tree generated by parsing the String to
 * complete.
 * 
 * @author Luigi Iannone
 */
public abstract class ParseTreeBasedAutoCompletionMatcher implements
    AutoCompletionMatcher {

    private final TreeAdaptor adaptor = new CommonTreeAdaptor() {

        @Override
        public Object create(Token token) {
            return new ManchesterOWLSyntaxTree(token);
        }

        @Override
        public Object dupNode(Object t) {
            if (t == null) {
                return null;
            }
            return this.create(((ManchesterOWLSyntaxTree) t).token);
        }

        @Override
        public Object errorNode(TokenStream input, Token start, Token stop,
            RecognitionException e) {
            return new CommonErrorNode(input, start, stop, e);
        }
    };
    private static ErrorListener silentErrorListener = new ErrorListener() {

        @Override
        public void unrecognisedSymbol(CommonTree t) {}

        @Override
        public void rewriteEmptyStreamException(RewriteEmptyStreamException e) {}

        @Override
        public void recognitionException(RecognitionException e, String... tokenNames) {}

        @Override
        public void recognitionException(RecognitionException e) {}

        @Override
        public void incompatibleSymbols(CommonTree parentExpression, CommonTree... trees) {}

        @Override
        public void incompatibleSymbolType(CommonTree t, Type type, CommonTree expression) {}

        @Override
        public void illegalToken(CommonTree t, String message) {}

        @Override
        public void reportThrowable(Throwable t, int line, int charPosInLine, int length) {}
    };

    @Override
    public List<String> getMatches(String string2Complete) {
        List<String> toReturn = new ArrayList<>();
        boolean newWord = string2Complete.matches(".*\\s");
        MOWLLexer lexer = new MOWLLexer(new ANTLRStringStream(string2Complete));
        TokenRewriteStream tokens = new TokenRewriteStream(lexer);
        ManchesterOWLSyntaxAutoCompleteCombinedParser parser = new ManchesterOWLSyntaxAutoCompleteCombinedParser(
            tokens);
        parser.setTreeAdaptor(adaptor);
        RuleReturnScope r = parser.main();
        ManchesterOWLSyntaxTree tree = (ManchesterOWLSyntaxTree) r.getTree();
        if (tree != null) {
            CommonTreeNodeStream nodes = new CommonTreeNodeStream(tree);
            nodes.setTokenStream(tokens); // where to find tokens
            nodes.setTreeAdaptor(adaptor);
            ManchesterOWLSyntaxSimplify simplify = new ManchesterOWLSyntaxSimplify(nodes);
            simplify.setTreeAdaptor(adaptor);
            simplify.downup(tree);
            nodes.reset();
            ManchesterOWLSyntaxTypes types = new ManchesterOWLSyntaxTypes(nodes,
                getSymbolTable(), silentErrorListener);
            types.downup(tree);
            nodes.reset();
            ManchesterOWLSyntaxAutoComplete autoComplete = new ManchesterOWLSyntaxAutoComplete(
                nodes, getSymbolTable());
            autoComplete.setNewWord(newWord);
            autoComplete.downup(tree);
            if (tree.getCompletions() != null) {
                toReturn.addAll(tree.getCompletions());
            }
        }
        return toReturn;
    }

    protected abstract SymbolTable getSymbolTable();
}
