/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.ui.autocompletionmatcher.AutoCompletionMatcher;

public final class AutoCompleter {
    private static final int DEFAULT_MAX_ENTRIES = 100;
    protected final JTextComponent textComponent;
    private final Set<String> wordDelimeters;
    private final JList popupList;
    protected JWindow popupWindow;
    private final AutoCompletionMatcher matcher;
    private static final int POPUP_WIDTH = 350;
    private static final int POPUP_HEIGHT = 300;
    protected String lastTextUpdate = "*";
    private final int maxEntries = 100;
    private final KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            AutoCompleter.this.processKeyPressed(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() != 38 && e.getKeyCode() != 40 && AutoCompleter.this.popupWindow.isVisible() && !AutoCompleter.this.lastTextUpdate.equals(AutoCompleter.this.textComponent.getText())) {
                AutoCompleter.this.lastTextUpdate = AutoCompleter.this.textComponent.getText();
                AutoCompleter.this.updatePopup(AutoCompleter.this.getMatches());
            }
        }
    };
    protected final ComponentAdapter componentListener = new ComponentAdapter(){

        @Override
        public void componentHidden(ComponentEvent event) {
            AutoCompleter.this.hidePopup();
        }

        @Override
        public void componentResized(ComponentEvent event) {
            AutoCompleter.this.hidePopup();
        }

        @Override
        public void componentMoved(ComponentEvent event) {
            AutoCompleter.this.hidePopup();
        }
    };
    private final HierarchyListener hierarchyListener = new HierarchyListener(){

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 1L) != 0L) {
                AutoCompleter.this.createPopupWindow();
                Container frame = AutoCompleter.this.textComponent.getTopLevelAncestor();
                if (frame != null) {
                    frame.addComponentListener(AutoCompleter.this.componentListener);
                }
            }
        }
    };
    private final MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                AutoCompleter.this.completeWithPopupSelection();
            }
        }
    };
    private final FocusListener focusListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent event) {
            AutoCompleter.this.hidePopup();
        }
    };

    public AutoCompleter(JTextComponent tc, AutoCompletionMatcher matcher) {
        this.matcher = ArgCheck.checkNotNull(matcher, "matcher");
        this.textComponent = ArgCheck.checkNotNull(tc, "tc");
        this.wordDelimeters = new HashSet<String>(Arrays.asList(" ", "\n", "[", "]", "{", "}", "(", ")", ",", "^"));
        this.popupList = new JList();
        this.popupList.setAutoscrolls(true);
        this.popupList.addMouseListener(this.mouseListener);
        this.popupList.setRequestFocusEnabled(false);
        this.textComponent.addKeyListener(this.keyListener);
        this.textComponent.addHierarchyListener(this.hierarchyListener);
        this.textComponent.addComponentListener(this.componentListener);
        this.textComponent.addFocusListener(this.focusListener);
        this.createPopupWindow();
    }

    public void cancel() {
        this.hidePopup();
    }

    protected void processKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32 && e.isControlDown()) {
            this.performAutoCompletion();
        } else if (e.getKeyCode() == 9) {
            e.consume();
            this.performAutoCompletion();
        } else if (e.getKeyCode() == 27) {
            if (this.popupWindow.isVisible()) {
                e.consume();
                this.hidePopup();
            }
        } else if (e.getKeyCode() == 10) {
            if (this.popupWindow.isVisible()) {
                e.consume();
                this.completeWithPopupSelection();
            }
        } else if (e.getKeyCode() == 40) {
            if (this.popupWindow.isVisible()) {
                e.consume();
                this.incrementSelection();
            }
        } else if (e.getKeyCode() == 38) {
            if (this.popupWindow.isVisible()) {
                e.consume();
                this.decrementSelection();
            }
        } else if (e.getKeyCode() == 37) {
            this.hidePopup();
        } else if (e.getKeyCode() == 39) {
            this.hidePopup();
        }
    }

    protected void completeWithPopupSelection() {
        Object selObject;
        if (this.popupWindow.isVisible() && (selObject = this.popupList.getSelectedValue()) != null) {
            this.insertWord(selObject.toString());
            this.hidePopup();
        }
    }

    protected List<String> getMatches() {
        return this.matcher.getMatches(this.getWordToComplete());
    }

    protected void createPopupWindow() {
        JScrollPane sp = new JScrollPane(this.popupList);
        this.popupWindow = new JWindow((Window)SwingUtilities.getAncestorOfClass(Window.class, this.textComponent));
        this.popupWindow.getContentPane().setLayout(new BorderLayout());
        this.popupWindow.getContentPane().add((Component)sp, "Center");
        this.popupWindow.setFocusableWindowState(false);
    }

    private void performAutoCompletion() {
        List<String> matches = this.getMatches();
        if (matches.size() == 1) {
            this.insertWord(matches.iterator().next());
        } else if (matches.size() > 1) {
            this.lastTextUpdate = this.textComponent.getText();
            this.showPopup();
            this.updatePopup(matches);
        }
    }

    private void insertWord(String word) {
        try {
            int selStart = this.textComponent.getSelectionStart();
            int selEnd = this.textComponent.getSelectionEnd();
            int selLen = selEnd - selStart;
            if (selLen > 0) {
                this.textComponent.getDocument().remove(selStart, selLen);
            }
            int index = this.getWordIndex();
            int caretIndex = this.textComponent.getCaretPosition();
            if (caretIndex > 0 && caretIndex > index) {
                this.textComponent.getDocument().remove(index, caretIndex - index);
            }
            this.textComponent.getDocument().insertString(index, word + " ", null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void showPopup() {
        if (this.popupWindow == null) {
            this.createPopupWindow();
        }
        if (!this.popupWindow.isVisible()) {
            this.popupWindow.setSize(350, 300);
            try {
                int wordIndex = this.getWordIndex();
                Point p = new Point(0, 0);
                if (wordIndex > 0) {
                    p = this.textComponent.modelToView(wordIndex).getLocation();
                }
                SwingUtilities.convertPointToScreen(p, this.textComponent);
                p.y += this.textComponent.getFontMetrics(this.textComponent.getFont()).getHeight();
                this.popupWindow.setLocation(p);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            this.popupWindow.setVisible(true);
        }
    }

    protected void hidePopup() {
        this.popupWindow.setVisible(false);
        this.popupList.setListData(new String[0]);
    }

    protected void updatePopup(List<String> matches) {
        int count = matches.size();
        if (count > 100) {
            count = 100;
        }
        String[] value = matches.subList(0, count).toArray(new String[count]);
        if (!matches.isEmpty()) {
            this.popupList.setListData(value);
        }
        this.popupList.setSelectedIndex(0);
        this.popupWindow.setSize(350, 300);
    }

    private void incrementSelection() {
        if (this.popupList.getModel().getSize() > 0) {
            int selIndex = this.popupList.getSelectedIndex();
            if (++selIndex > this.popupList.getModel().getSize() - 1) {
                selIndex = 0;
            }
            this.popupList.setSelectedIndex(selIndex);
            this.popupList.scrollRectToVisible(this.popupList.getCellBounds(selIndex, selIndex));
        }
    }

    private void decrementSelection() {
        if (this.popupList.getModel().getSize() > 0) {
            int selIndex = this.popupList.getSelectedIndex();
            if (--selIndex < 0) {
                selIndex = this.popupList.getModel().getSize() - 1;
            }
            this.popupList.setSelectedIndex(selIndex);
            this.popupList.scrollRectToVisible(this.popupList.getCellBounds(selIndex, selIndex));
        }
    }

    private int getWordIndex() {
        int index = this.getEscapedWordIndex();
        if (index == -1) {
            index = this.getUnbrokenWordIndex();
        }
        return Math.max(0, index);
    }

    private int getEscapedWordIndex() {
        try {
            int escapeStart;
            int caretPos = Math.max(0, this.getEffectiveCaretPosition() - 1);
            String expression = this.textComponent.getDocument().getText(0, caretPos);
            int escapeEnd = -1;
            while ((escapeStart = expression.indexOf("'", escapeEnd + 1)) != -1) {
                escapeEnd = expression.indexOf("'", escapeStart + 1);
                if (escapeEnd != -1) continue;
                return escapeStart;
            }
            return -1;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private int getUnbrokenWordIndex() {
        try {
            int caretPos = Math.max(0, this.getEffectiveCaretPosition() - 1);
            if (caretPos > 0) {
                for (int index = caretPos; index > -1; --index) {
                    if (this.wordDelimeters.contains(this.textComponent.getDocument().getText(index, 1))) {
                        return index + 1;
                    }
                    if (index != 0) continue;
                    return 0;
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return -1;
    }

    private String getWordToComplete() {
        try {
            int index = this.getWordIndex();
            int caretIndex = this.getEffectiveCaretPosition();
            return this.textComponent.getDocument().getText(index, caretIndex - index);
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    private int getEffectiveCaretPosition() {
        int startSel = this.textComponent.getSelectionStart();
        if (startSel >= 0) {
            return startSel;
        }
        return this.textComponent.getCaretPosition();
    }

    public void uninstall() {
        this.hidePopup();
        this.textComponent.removeKeyListener(this.keyListener);
        this.textComponent.removeComponentListener(this.componentListener);
        this.textComponent.removeFocusListener(this.focusListener);
        this.textComponent.removeHierarchyListener(this.hierarchyListener);
    }
}

