/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.utils.OWLObjectDecomposer;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;

public class OWLObjectFinder {
    public static List<List<Integer>> findAll(OWLObject key, OWLObject container) {
        ArgCheck.checkNotNull(key, "key");
        ArgCheck.checkNotNull(container, "container");
        List<List<Integer>> toReturn = key.equals(container) ? Collections.singletonList(Collections.singletonList(0)) : OWLObjectFinder.findAll(key, container, Collections.<Integer>emptyList());
        return toReturn;
    }

    private static List<List<Integer>> findAll(OWLObject key, OWLObject container, List<Integer> position) {
        ArrayList<List<Integer>> toReturn = new ArrayList<List<Integer>>();
        OWLObjectDecomposer decomposer = new OWLObjectDecomposer();
        List decomposition = (List)container.accept((OWLObjectVisitorEx)decomposer);
        if (!decomposition.isEmpty()) {
            Iterator iterator = decomposition.iterator();
            int i = 1;
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (OWLObject.class.isAssignableFrom(object.getClass())) {
                    OWLObject toCompare = (OWLObject)object;
                    ArrayList<Integer> newPosition = new ArrayList<Integer>(position);
                    newPosition.add(i);
                    if (key.equals(toCompare)) {
                        toReturn.add(newPosition);
                    } else {
                        toReturn.addAll(OWLObjectFinder.findAll(key, toCompare, newPosition));
                    }
                } else {
                    iterator.remove();
                }
                ++i;
            }
        }
        return toReturn;
    }
}

