/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.search.solvability;

import java.util.Set;
import org.coode.oppl.search.solvability.QuerySolver;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public final class InferredModelQuerySolver
implements QuerySolver {
    private final OWLReasoner reasoner;

    public InferredModelQuerySolver(OWLReasoner reasoner) {
        this.reasoner = ArgCheck.checkNotNull(reasoner, "reasoner");
    }

    @Override
    public Set<OWLClass> getSubClasses(OWLClassExpression superClass) {
        Set toReturn = this.reasoner.getSubClasses(superClass, false).getFlattened();
        toReturn.addAll(this.reasoner.getEquivalentClasses(superClass).getEntities());
        if (!superClass.isAnonymous()) {
            toReturn.add(superClass.asOWLClass());
        }
        return toReturn;
    }

    @Override
    public Set<OWLClass> getSuperClasses(OWLClassExpression subClass) {
        Set toReturn = this.reasoner.getSuperClasses(subClass, false).getFlattened();
        toReturn.addAll(this.reasoner.getEquivalentClasses(subClass).getEntities());
        if (!subClass.isAnonymous()) {
            toReturn.add(subClass.asOWLClass());
        }
        return toReturn;
    }

    @Override
    public boolean hasNoSubClass(OWLClassExpression superClass) {
        Set subClasses = this.reasoner.getSubClasses(superClass, false).getFlattened();
        subClasses.addAll(this.reasoner.getEquivalentClasses(superClass).getEntities());
        subClasses.remove(superClass);
        subClasses.removeAll(this.reasoner.getBottomClassNode().getEntities());
        return subClasses.isEmpty();
    }

    @Override
    public boolean hasNoSuperClass(OWLClassExpression subClass) {
        Set superClasses = this.reasoner.getSubClasses(subClass, false).getFlattened();
        superClasses.addAll(this.reasoner.getEquivalentClasses(subClass).getEntities());
        superClasses.remove(subClass);
        superClasses.removeAll(this.reasoner.getTopClassNode().getEntities());
        return superClasses.isEmpty();
    }

    @Override
    public Set<OWLNamedIndividual> getNamedFillers(OWLNamedIndividual subject, OWLObjectPropertyExpression objectProperty) {
        NodeSet fillers = this.reasoner.getObjectPropertyValues(subject, objectProperty);
        return fillers.getFlattened();
    }
}

