/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.coode.oppl.PartialOWLObjectInstantiator;
import org.coode.oppl.Variable;
import org.coode.oppl.VariableVisitorEx;
import org.coode.oppl.bindingtree.Assignment;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.generated.GeneratedVariable;
import org.coode.oppl.generated.RegexpGeneratedVariable;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.coode.oppl.search.SearchTree;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.utils.OWLObjectExtractor;
import org.coode.oppl.utils.VariableExtractor;
import org.coode.oppl.variabletypes.ANNOTATIONPROPERTYVariableType;
import org.coode.oppl.variabletypes.CLASSVariableType;
import org.coode.oppl.variabletypes.CONSTANTVariableType;
import org.coode.oppl.variabletypes.DATAPROPERTYVariableType;
import org.coode.oppl.variabletypes.INDIVIDUALVariableType;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.oppl.variabletypes.OBJECTPROPERTYVariableType;
import org.coode.oppl.variabletypes.VariableTypeVisitorEx;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;

public class OWLAxiomSearchTree
extends SearchTree<OWLAxiom> {
    private final ValueComputationParameters parameters;
    protected final VariableTypeVisitorEx<Set<? extends OWLObject>> assignableValuesVisitor = new VariableTypeVisitorEx<Set<? extends OWLObject>>(){

        @Override
        public Set<? extends OWLObject> visitCLASSVariableType(CLASSVariableType classVariableType) {
            return OWLAxiomSearchTree.this.getAllClasses();
        }

        @Override
        public Set<? extends OWLObject> visitOBJECTPROPERTYVariableType(OBJECTPROPERTYVariableType objectpropertyVariableType) {
            return OWLAxiomSearchTree.this.getObjectProperties();
        }

        @Override
        public Set<? extends OWLObject> visitDATAPROPERTYVariableType(DATAPROPERTYVariableType datapropertyVariableType) {
            return OWLAxiomSearchTree.this.getAllDataProperties();
        }

        @Override
        public Set<? extends OWLObject> visitANNOTATIONPROPERTYVariableType(ANNOTATIONPROPERTYVariableType annotationpropertyVariableType) {
            return OWLAxiomSearchTree.this.getAllAnnotationProperties();
        }

        @Override
        public Set<? extends OWLObject> visitINDIVIDUALVariableType(INDIVIDUALVariableType individualVariableType) {
            return OWLAxiomSearchTree.this.getAllIndividuals();
        }

        @Override
        public Set<? extends OWLObject> visitCONSTANTVariableType(CONSTANTVariableType constantVariableType) {
            return OWLAxiomSearchTree.this.getAllConstants();
        }
    };

    public OWLAxiomSearchTree(ValueComputationParameters parameters) {
        this.parameters = ArgCheck.checkNotNull(parameters, "parameters");
    }

    public ValueComputationParameters getParameters() {
        return this.parameters;
    }

    @Override
    protected List<OWLAxiom> getChildren(OWLAxiom node) {
        Set<BindingNode> leaves = this.getParameters().getConstraintSystem().getLeaves();
        ArrayList<OWLAxiom> toReturn = new ArrayList<OWLAxiom>();
        VariableExtractor variableExtractor = new VariableExtractor(this.getParameters().getConstraintSystem(), false);
        Set<Variable<?>> variables = variableExtractor.extractVariables((OWLObject)node);
        if (!variables.isEmpty()) {
            Variable<?> variable = variables.iterator().next();
            HashSet<Object> values = new HashSet<Object>();
            if (leaves == null) {
                values.addAll(this.getAssignableValues(variable));
            } else {
                for (BindingNode bindingNode : leaves) {
                    SimpleValueComputationParameters pars = new SimpleValueComputationParameters(this.getParameters().getConstraintSystem(), bindingNode, this.getParameters().getRuntimeExceptionHandler());
                    if (bindingNode.containsAssignedVariable(variable)) {
                        values.add(this.getParameters().getBindingNode().getAssignmentValue(variable, pars));
                        continue;
                    }
                    values.addAll(this.getAssignableValues(variable));
                }
            }
            for (OWLObject oWLObject : values) {
                Assignment assignment = new Assignment(variable, oWLObject);
                BindingNode bindingNode = new BindingNode(Collections.singleton(assignment), variables);
                SimpleValueComputationParameters par = new SimpleValueComputationParameters(this.getParameters().getConstraintSystem(), bindingNode, this.getParameters().getRuntimeExceptionHandler());
                PartialOWLObjectInstantiator instantiator = new PartialOWLObjectInstantiator(par);
                toReturn.add((OWLAxiom)node.accept((OWLObjectVisitorEx)instantiator));
            }
        }
        return toReturn;
    }

    @Override
    protected boolean goalReached(OWLAxiom start) {
        boolean found = false;
        Iterator iterator = this.getParameters().getConstraintSystem().getOntologyManager().getOntologies().iterator();
        while (!found && iterator.hasNext()) {
            OWLOntology ontology = (OWLOntology)iterator.next();
            found = ontology.containsAxiom(start);
        }
        return found;
    }

    protected Set<OWLClass> getAllClasses() {
        HashSet<OWLClass> toReturn = new HashSet<OWLClass>();
        Set ontologies = this.getParameters().getConstraintSystem().getOntologyManager().getOntologies();
        for (OWLOntology owlOntology : ontologies) {
            toReturn.addAll(owlOntology.getClassesInSignature());
        }
        return toReturn;
    }

    protected Set<OWLLiteral> getAllConstants() {
        HashSet<OWLLiteral> toReturn = new HashSet<OWLLiteral>();
        for (OWLOntology ontology : this.getParameters().getConstraintSystem().getOntologyManager().getOntologies()) {
            for (OWLAxiom axiom : ontology.getAxioms()) {
                toReturn.addAll(OWLObjectExtractor.getAllOWLLiterals((OWLObject)axiom));
            }
        }
        return toReturn;
    }

    protected Set<OWLDataProperty> getAllDataProperties() {
        HashSet<OWLDataProperty> toReturn = new HashSet<OWLDataProperty>();
        Set ontologies = this.getParameters().getConstraintSystem().getOntologyManager().getOntologies();
        for (OWLOntology owlOntology : ontologies) {
            toReturn.addAll(owlOntology.getDataPropertiesInSignature());
        }
        return toReturn;
    }

    protected Set<OWLAnnotationProperty> getAllAnnotationProperties() {
        HashSet<OWLAnnotationProperty> toReturn = new HashSet<OWLAnnotationProperty>();
        Set ontologies = this.getParameters().getConstraintSystem().getOntologyManager().getOntologies();
        for (OWLOntology owlOntology : ontologies) {
            toReturn.addAll(owlOntology.getAnnotationPropertiesInSignature());
        }
        return toReturn;
    }

    protected Set<OWLNamedIndividual> getAllIndividuals() {
        HashSet<OWLNamedIndividual> toReturn = new HashSet<OWLNamedIndividual>();
        Set ontologies = this.getParameters().getConstraintSystem().getOntologyManager().getOntologies();
        for (OWLOntology owlOntology : ontologies) {
            toReturn.addAll(owlOntology.getIndividualsInSignature());
        }
        return toReturn;
    }

    private Collection<? extends OWLObject> getAssignableValues(Variable<?> variable) {
        HashSet toReturn = new HashSet();
        VariableVisitorEx<Set<? extends OWLObject>> visitor = new VariableVisitorEx<Set<? extends OWLObject>>(){

            @Override
            public <O extends OWLObject> Set<? extends OWLObject> visit(InputVariable<O> v) {
                return v.getType().accept(OWLAxiomSearchTree.this.assignableValuesVisitor);
            }

            @Override
            public <O extends OWLObject> Set<? extends OWLObject> visit(RegexpGeneratedVariable<O> v) {
                Set<? extends OWLObject> result = v.getType().accept(OWLAxiomSearchTree.this.assignableValuesVisitor);
                Iterator<? extends OWLObject> iterator = result.iterator();
                while (iterator.hasNext()) {
                    OWLObject owlObject = iterator.next();
                    ManchesterSyntaxRenderer renderer = OWLAxiomSearchTree.this.getParameters().getConstraintSystem().getOPPLFactory().getManchesterSyntaxRenderer(OWLAxiomSearchTree.this.getParameters().getConstraintSystem());
                    owlObject.accept((OWLObjectVisitor)renderer);
                    if (v.getPatternGeneratingOPPLFunction().compute(OWLAxiomSearchTree.this.getParameters()).matcher(renderer.toString()).matches()) continue;
                    iterator.remove();
                }
                return result;
            }

            @Override
            public <O extends OWLObject> Set<? extends OWLObject> visit(GeneratedVariable<O> v) {
                return Collections.emptySet();
            }
        };
        toReturn.addAll(variable.accept(visitor));
        return toReturn;
    }

    protected Set<OWLObjectProperty> getObjectProperties() {
        HashSet<OWLObjectProperty> toReturn = new HashSet<OWLObjectProperty>();
        Set ontologies = this.getParameters().getConstraintSystem().getOntologyManager().getOntologies();
        for (OWLOntology owlOntology : ontologies) {
            toReturn.addAll(owlOntology.getObjectPropertiesInSignature());
        }
        return toReturn;
    }

    public VariableTypeVisitorEx<Set<? extends OWLObject>> getAssignableValuesVisitor() {
        return this.assignableValuesVisitor;
    }
}

