/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.PartialOWLObjectInstantiator;
import org.coode.oppl.Variable;
import org.coode.oppl.VariableScope;
import org.coode.oppl.bindingtree.Assignment;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.log.Logging;
import org.coode.oppl.queryplanner.ConstantExtractor;
import org.coode.oppl.search.AssignableValueExtractor;
import org.coode.oppl.search.OPPLOWLAxiomSearchNode;
import org.coode.oppl.search.SearchTree;
import org.coode.oppl.utils.AbstractVariableVisitorExAdapter;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.utils.ConstantCollector;
import org.coode.oppl.utils.VariableExtractor;
import org.coode.oppl.variabletypes.ANNOTATIONPROPERTYVariableType;
import org.coode.oppl.variabletypes.CLASSVariableType;
import org.coode.oppl.variabletypes.CONSTANTVariableType;
import org.coode.oppl.variabletypes.DATAPROPERTYVariableType;
import org.coode.oppl.variabletypes.INDIVIDUALVariableType;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.oppl.variabletypes.OBJECTPROPERTYVariableType;
import org.coode.oppl.variabletypes.VariableTypeVisitorEx;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public abstract class AbstractOPPLAxiomSearchTree
extends SearchTree<OPPLOWLAxiomSearchNode> {
    private final ConstraintSystem constraintSystem;
    private final RuntimeExceptionHandler runtimeExceptionHandler;
    protected final Set<OWLClass> allClasses = new HashSet<OWLClass>();
    protected final Set<OWLObjectProperty> allObjectProperties = new HashSet<OWLObjectProperty>();
    protected final Set<OWLAnnotationProperty> allAnnotationProperties = new HashSet<OWLAnnotationProperty>();
    protected final Set<OWLDataProperty> allDataProperties = new HashSet<OWLDataProperty>();
    protected final Set<OWLIndividual> allIndividuals = new HashSet<OWLIndividual>();
    protected final Set<OWLLiteral> allConstants = new HashSet<OWLLiteral>();
    private final VariableTypeVisitorEx<Set<? extends OWLObject>> assignableValuesVisitor = new VariableTypeVisitorEx<Set<? extends OWLObject>>(){

        @Override
        public Set<? extends OWLObject> visitCLASSVariableType(CLASSVariableType classVariableType) {
            return AbstractOPPLAxiomSearchTree.this.allClasses;
        }

        @Override
        public Set<? extends OWLObject> visitOBJECTPROPERTYVariableType(OBJECTPROPERTYVariableType objectpropertyVariableType) {
            return AbstractOPPLAxiomSearchTree.this.allObjectProperties;
        }

        @Override
        public Set<? extends OWLObject> visitDATAPROPERTYVariableType(DATAPROPERTYVariableType datapropertyVariableType) {
            return AbstractOPPLAxiomSearchTree.this.allDataProperties;
        }

        @Override
        public Set<? extends OWLObject> visitINDIVIDUALVariableType(INDIVIDUALVariableType individualVariableType) {
            return AbstractOPPLAxiomSearchTree.this.allIndividuals;
        }

        @Override
        public Set<? extends OWLObject> visitCONSTANTVariableType(CONSTANTVariableType constantVariableType) {
            return AbstractOPPLAxiomSearchTree.this.allConstants;
        }

        @Override
        public Set<? extends OWLObject> visitANNOTATIONPROPERTYVariableType(ANNOTATIONPROPERTYVariableType annotationpropertyVariableType) {
            return AbstractOPPLAxiomSearchTree.this.allAnnotationProperties;
        }
    };

    protected AbstractOPPLAxiomSearchTree(ConstraintSystem constraintSystem, RuntimeExceptionHandler runtimeExceptionHandler) {
        this.constraintSystem = ArgCheck.checkNotNull(constraintSystem, "constraintSystem");
        this.runtimeExceptionHandler = ArgCheck.checkNotNull(runtimeExceptionHandler, "runtimeExceptionHandler");
    }

    @Override
    protected abstract boolean goalReached(OPPLOWLAxiomSearchNode var1);

    @Override
    protected List<OPPLOWLAxiomSearchNode> getChildren(OPPLOWLAxiomSearchNode node) {
        ArrayList<OPPLOWLAxiomSearchNode> toReturn = new ArrayList<OPPLOWLAxiomSearchNode>();
        Set<Variable<?>> variables = node.getBinding().getUnassignedVariables();
        BindingNode binding = node.getBinding();
        SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(this.getConstraintSystem(), node.getBinding(), this.getRuntimeExceptionHandler());
        if (!variables.isEmpty()) {
            Variable<?> variable = variables.iterator().next();
            HashSet<? extends OWLObject> values = new HashSet<OWLObject>();
            values.addAll(this.getAssignableValues(variable, parameters));
            for (OWLObject oWLObject : values) {
                Assignment assignment = new Assignment(variable, oWLObject);
                BindingNode childBinding = new BindingNode(binding);
                childBinding.addAssignment(assignment);
                SimpleValueComputationParameters newParameters = new SimpleValueComputationParameters(this.getConstraintSystem(), childBinding, this.getRuntimeExceptionHandler());
                PartialOWLObjectInstantiator instantiator = new PartialOWLObjectInstantiator(newParameters);
                OWLAxiom instantiatedAxiom = (OWLAxiom)node.getAxiom().accept((OWLObjectVisitorEx)instantiator);
                OPPLOWLAxiomSearchNode child = new OPPLOWLAxiomSearchNode(instantiatedAxiom, childBinding);
                toReturn.add(child);
            }
        }
        return toReturn;
    }

    private Collection<OWLClass> getAllClasses() {
        HashSet<OWLClass> toReturn = new HashSet<OWLClass>();
        for (OWLOntology owlOntology : this.getConstraintSystem().getOntologyManager().getOntologies()) {
            toReturn.addAll(owlOntology.getClassesInSignature());
        }
        return toReturn;
    }

    private Collection<OWLLiteral> getAllConstants() {
        HashSet<OWLLiteral> toReturn = new HashSet<OWLLiteral>();
        ConstantExtractor constantExtractor = new ConstantExtractor(toReturn);
        ConstantCollector visitor = new ConstantCollector(toReturn, (OWLClassExpressionVisitor)constantExtractor);
        for (OWLOntology owlOntology : this.getConstraintSystem().getOntologyManager().getOntologies()) {
            for (OWLAxiom axiomToVisit : owlOntology.getAxioms()) {
                axiomToVisit.accept((OWLAxiomVisitor)visitor);
            }
        }
        return toReturn;
    }

    private Collection<OWLDataProperty> getAllDataProperties() {
        HashSet<OWLDataProperty> toReturn = new HashSet<OWLDataProperty>();
        for (OWLOntology owlOntology : this.getConstraintSystem().getOntologyManager().getOntologies()) {
            toReturn.addAll(owlOntology.getDataPropertiesInSignature());
        }
        return toReturn;
    }

    private Collection<OWLIndividual> getAllIndividuals() {
        HashSet<OWLIndividual> toReturn = new HashSet<OWLIndividual>();
        for (OWLOntology owlOntology : this.getConstraintSystem().getOntologyManager().getOntologies()) {
            toReturn.addAll(owlOntology.getIndividualsInSignature());
        }
        return toReturn;
    }

    private Collection<? extends OWLObject> getAssignableValues(Variable<?> variable, ValueComputationParameters parameters) {
        HashSet toReturn = new HashSet();
        toReturn.addAll(variable.accept(new AssignableValueExtractor(this.assignableValuesVisitor, parameters)));
        Iterator iterator = toReturn.iterator();
        while (iterator.hasNext()) {
            final OWLObject owlObject = (OWLObject)iterator.next();
            boolean inScope = variable.accept(new AbstractVariableVisitorExAdapter<Boolean>(Boolean.valueOf(true)){

                @Override
                public <P extends OWLObject> Boolean visit(InputVariable<P> v) {
                    VariableScope<?> variableScope = v.getVariableScope();
                    try {
                        return variableScope == null || variableScope.check(owlObject);
                    }
                    catch (OWLRuntimeException e) {
                        AbstractOPPLAxiomSearchTree.this.getRuntimeExceptionHandler().handleOWLRuntimeException(e);
                        return false;
                    }
                }
            });
            if (inScope) continue;
            iterator.remove();
        }
        return toReturn;
    }

    private void initAssignableValues() {
        this.allClasses.addAll(this.getAllClasses());
        Logging.getQueryLogger().fine("Possible class values ", (Object)this.allClasses.size());
        this.allDataProperties.addAll(this.getAllDataProperties());
        Logging.getQueryLogger().fine("Possible data property values ", (Object)this.allDataProperties.size());
        this.allObjectProperties.addAll(this.getObjectProperties());
        Logging.getQueryLogger().fine("Possible object property values ", (Object)this.allObjectProperties.size());
        this.allIndividuals.addAll(this.getAllIndividuals());
        Logging.getQueryLogger().fine("Possible individual  values ", (Object)this.allIndividuals.size());
        this.allConstants.addAll(this.getAllConstants());
        Logging.getQueryLogger().fine("Possible constant  values ", (Object)this.allConstants.size());
        this.allAnnotationProperties.addAll(this.getAllAnnotationProperties());
        Logging.getQueryLogger().fine("Possible annotation properties values ", (Object)this.allAnnotationProperties.size());
    }

    private Set<OWLAnnotationProperty> getAllAnnotationProperties() {
        HashSet<OWLAnnotationProperty> toReturn = new HashSet<OWLAnnotationProperty>();
        for (OWLOntology ontology : this.getConstraintSystem().getOntologyManager().getOntologies()) {
            toReturn.addAll(ontology.getAnnotationPropertiesInSignature());
        }
        return toReturn;
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    private Collection<OWLObjectProperty> getObjectProperties() {
        HashSet<OWLObjectProperty> toReturn = new HashSet<OWLObjectProperty>();
        for (OWLOntology owlOntology : this.getConstraintSystem().getOntologyManager().getOntologies()) {
            toReturn.addAll(owlOntology.getObjectPropertiesInSignature());
        }
        return toReturn;
    }

    @Override
    public boolean exhaustiveSearchTree(OPPLOWLAxiomSearchNode start, List<List<OPPLOWLAxiomSearchNode>> solutions) {
        this.initAssignableValues();
        Set<BindingNode> existingLeaves = this.getConstraintSystem().getLeaves();
        boolean found = false;
        if (existingLeaves != null) {
            Logging.getQueryTestLogging().fine("Existing leaves count: ", (Object)existingLeaves.size());
            int leafIndex = 1;
            for (BindingNode bindingNode : existingLeaves) {
                Logging.getQueryTestLogging().fine("Exhaustive search on leaf: ", leafIndex, " out of ", existingLeaves.size());
                ++leafIndex;
                SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(this.getConstraintSystem(), bindingNode, this.getRuntimeExceptionHandler());
                PartialOWLObjectInstantiator partialObjectInstantiator = new PartialOWLObjectInstantiator(parameters);
                OWLAxiom newStartAxiom = (OWLAxiom)start.getAxiom().accept((OWLObjectVisitorEx)partialObjectInstantiator);
                VariableExtractor variableExtractor = new VariableExtractor(this.getConstraintSystem(), false);
                BindingNode newBindingNode = new BindingNode(bindingNode.getAssignments(), variableExtractor.extractVariables((OWLObject)newStartAxiom));
                OPPLOWLAxiomSearchNode newStart = new OPPLOWLAxiomSearchNode(newStartAxiom, newBindingNode);
                ArrayList bindingNodeSolutions = new ArrayList();
                boolean bindingNodeSearch = super.exhaustiveSearchTree(newStart, bindingNodeSolutions);
                boolean bl = found = found || bindingNodeSearch;
                if (!bindingNodeSearch) continue;
                solutions.addAll(bindingNodeSolutions);
            }
        } else {
            found = super.exhaustiveSearchTree(start, solutions);
        }
        HashSet<BindingNode> newLeaves = new HashSet<BindingNode>();
        for (List list : solutions) {
            OPPLOWLAxiomSearchNode leafSerachNode = (OPPLOWLAxiomSearchNode)list.get(list.size() - 1);
            BindingNode newLeaf = leafSerachNode.getBinding();
            newLeaves.add(newLeaf);
        }
        return found;
    }

    public RuntimeExceptionHandler getRuntimeExceptionHandler() {
        return this.runtimeExceptionHandler;
    }
}

