/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.queryplanner;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.Variable;
import org.coode.oppl.VariableScope;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.log.Logging;
import org.coode.oppl.queryplanner.AssertedAxiomPlannerItem;
import org.coode.oppl.queryplanner.ConstantExtractor;
import org.coode.oppl.queryplanner.ConstraintQueryPlannerItem;
import org.coode.oppl.queryplanner.InferredAxiomQueryPlannerItem;
import org.coode.oppl.queryplanner.QueryPlannerVisitorEx;
import org.coode.oppl.search.AssignableValueExtractor;
import org.coode.oppl.utils.AbstractVariableVisitorExAdapter;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.utils.ConstantCollector;
import org.coode.oppl.utils.VariableExtractor;
import org.coode.oppl.variabletypes.ANNOTATIONPROPERTYVariableType;
import org.coode.oppl.variabletypes.CLASSVariableType;
import org.coode.oppl.variabletypes.CONSTANTVariableType;
import org.coode.oppl.variabletypes.DATAPROPERTYVariableType;
import org.coode.oppl.variabletypes.INDIVIDUALVariableType;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.oppl.variabletypes.OBJECTPROPERTYVariableType;
import org.coode.oppl.variabletypes.VariableTypeVisitorEx;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public class ComplexityEstimate
implements QueryPlannerVisitorEx<Float> {
    private final VariableExtractor variableExtractor;
    private final RuntimeExceptionHandler runtimeExceptionHandler;
    private final ConstraintSystem constraintSystem;
    private final VariableTypeVisitorEx<Set<? extends OWLObject>> assignableValuesVisitor = new VariableTypeVisitorEx<Set<? extends OWLObject>>(){

        @Override
        public Set<? extends OWLObject> visitCLASSVariableType(CLASSVariableType classVariableType) {
            return ComplexityEstimate.this.allClasses;
        }

        @Override
        public Set<? extends OWLObject> visitOBJECTPROPERTYVariableType(OBJECTPROPERTYVariableType objectpropertyVariableType) {
            return ComplexityEstimate.this.allObjectProperties;
        }

        @Override
        public Set<? extends OWLObject> visitDATAPROPERTYVariableType(DATAPROPERTYVariableType datapropertyVariableType) {
            return ComplexityEstimate.this.allDataProperties;
        }

        @Override
        public Set<? extends OWLObject> visitINDIVIDUALVariableType(INDIVIDUALVariableType individualVariableType) {
            return ComplexityEstimate.this.allIndividuals;
        }

        @Override
        public Set<? extends OWLObject> visitCONSTANTVariableType(CONSTANTVariableType constantVariableType) {
            return ComplexityEstimate.this.allConstants;
        }

        @Override
        public Set<? extends OWLObject> visitANNOTATIONPROPERTYVariableType(ANNOTATIONPROPERTYVariableType annotationpropertyVariableType) {
            return ComplexityEstimate.this.allAnnotationProperties;
        }
    };
    protected final Set<OWLAnnotationProperty> allAnnotationProperties = new HashSet<OWLAnnotationProperty>();
    protected final Set<OWLClass> allClasses = new HashSet<OWLClass>();
    protected final Set<OWLLiteral> allConstants = new HashSet<OWLLiteral>();
    protected final Set<OWLDataProperty> allDataProperties = new HashSet<OWLDataProperty>();
    protected final Set<OWLIndividual> allIndividuals = new HashSet<OWLIndividual>();
    protected final Set<OWLObjectProperty> allObjectProperties = new HashSet<OWLObjectProperty>();

    public ComplexityEstimate(ConstraintSystem contraintSystem, RuntimeExceptionHandler runtimeExceptionHandler) {
        this.constraintSystem = ArgCheck.checkNotNull(contraintSystem, "contraintSystem");
        this.runtimeExceptionHandler = ArgCheck.checkNotNull(runtimeExceptionHandler, "runtimeExceptionHandler");
        this.variableExtractor = new VariableExtractor(contraintSystem, false);
        this.initAssignableValues();
    }

    @Override
    public Float visitConstraintQueryPlannerItem(ConstraintQueryPlannerItem constraintQueryPlannerItem) {
        return Float.valueOf(0.0f);
    }

    @Override
    public Float visitAssertedAxiomPlannerItem(AssertedAxiomPlannerItem assertedAxiomPlannerItem) {
        return Float.valueOf(this.computeAxiomComplexity(assertedAxiomPlannerItem.getAxiom()));
    }

    private float computeAxiomComplexity(OWLAxiom axiom) {
        Set<Variable<?>> variables = this.variableExtractor.extractVariables((OWLObject)axiom);
        long toReturn = 1L;
        SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(this.getConstraintSystem(), BindingNode.createNewEmptyBindingNode(), this.getRuntimeExceptionHandler());
        for (Variable<?> variable : variables) {
            toReturn *= (long)this.getAssignableValues(variable, parameters).size();
        }
        return toReturn;
    }

    private Set<OWLObject> getAssignableValues(Variable<?> variable, ValueComputationParameters parameters) {
        HashSet<OWLObject> toReturn = new HashSet<OWLObject>();
        toReturn.addAll((Collection)variable.accept(new AssignableValueExtractor(this.assignableValuesVisitor, parameters)));
        Iterator iterator = toReturn.iterator();
        while (iterator.hasNext()) {
            final OWLObject owlObject = (OWLObject)iterator.next();
            boolean inScope = variable.accept(new AbstractVariableVisitorExAdapter<Boolean>(Boolean.valueOf(true)){

                @Override
                public <P extends OWLObject> Boolean visit(InputVariable<P> v) {
                    VariableScope<?> variableScope = v.getVariableScope();
                    try {
                        return variableScope == null || variableScope.check(owlObject);
                    }
                    catch (OWLRuntimeException e) {
                        ComplexityEstimate.this.getRuntimeExceptionHandler().handleOWLRuntimeException(e);
                        return false;
                    }
                }
            });
            if (inScope) continue;
            iterator.remove();
        }
        return toReturn;
    }

    @Override
    public Float visitInferredAxiomQueryPlannerItem(InferredAxiomQueryPlannerItem inferredAxiomQueryPlannerItem) {
        return Float.valueOf(this.computeAxiomComplexity(inferredAxiomQueryPlannerItem.getAxiom()));
    }

    protected VariableExtractor getVariableExtractor() {
        return this.variableExtractor;
    }

    public RuntimeExceptionHandler getRuntimeExceptionHandler() {
        return this.runtimeExceptionHandler;
    }

    private Set<OWLAnnotationProperty> getAllAnnotationProperties() {
        HashSet<OWLAnnotationProperty> toReturn = new HashSet<OWLAnnotationProperty>();
        for (OWLOntology ontology : this.getConstraintSystem().getOntologyManager().getOntologies()) {
            toReturn.addAll(ontology.getAnnotationPropertiesInSignature());
        }
        return toReturn;
    }

    private Collection<OWLClass> getAllClasses() {
        HashSet<OWLClass> toReturn = new HashSet<OWLClass>();
        for (OWLOntology owlOntology : this.getConstraintSystem().getOntologyManager().getOntologies()) {
            toReturn.addAll(owlOntology.getClassesInSignature());
        }
        return toReturn;
    }

    private Collection<OWLLiteral> getAllConstants() {
        HashSet<OWLLiteral> toReturn = new HashSet<OWLLiteral>();
        ConstantExtractor constantExtractor = new ConstantExtractor(toReturn);
        ConstantCollector visitor = new ConstantCollector(toReturn, (OWLClassExpressionVisitor)constantExtractor);
        for (OWLOntology owlOntology : this.getConstraintSystem().getOntologyManager().getOntologies()) {
            for (OWLAxiom axiomToVisit : owlOntology.getAxioms()) {
                axiomToVisit.accept((OWLAxiomVisitor)visitor);
            }
        }
        return toReturn;
    }

    private Collection<OWLDataProperty> getAllDataProperties() {
        HashSet<OWLDataProperty> toReturn = new HashSet<OWLDataProperty>();
        for (OWLOntology owlOntology : this.getConstraintSystem().getOntologyManager().getOntologies()) {
            toReturn.addAll(owlOntology.getDataPropertiesInSignature());
        }
        return toReturn;
    }

    private Collection<OWLIndividual> getAllIndividuals() {
        HashSet<OWLIndividual> toReturn = new HashSet<OWLIndividual>();
        for (OWLOntology owlOntology : this.getConstraintSystem().getOntologyManager().getOntologies()) {
            toReturn.addAll(owlOntology.getIndividualsInSignature());
        }
        return toReturn;
    }

    private Collection<OWLObjectProperty> getAllObjectProperties() {
        HashSet<OWLObjectProperty> toReturn = new HashSet<OWLObjectProperty>();
        for (OWLOntology owlOntology : this.getConstraintSystem().getOntologyManager().getOntologies()) {
            toReturn.addAll(owlOntology.getObjectPropertiesInSignature());
        }
        return toReturn;
    }

    private void initAssignableValues() {
        this.allClasses.addAll(this.getAllClasses());
        Logging.getQueryLogger().fine("Possible class values ", (Object)this.allClasses.size());
        this.allDataProperties.addAll(this.getAllDataProperties());
        Logging.getQueryLogger().fine("Possible data property values ", (Object)this.allDataProperties.size());
        this.allObjectProperties.addAll(this.getAllObjectProperties());
        Logging.getQueryLogger().fine("Possible object property values ", (Object)this.allObjectProperties.size());
        this.allIndividuals.addAll(this.getAllIndividuals());
        Logging.getQueryLogger().fine("Possible individual  values ", (Object)this.allIndividuals.size());
        this.allConstants.addAll(this.getAllConstants());
        Logging.getQueryLogger().fine("Possible constant  values ", (Object)this.allConstants.size());
        this.allAnnotationProperties.addAll(this.getAllAnnotationProperties());
        Logging.getQueryLogger().fine("Possible annotation properties values ", (Object)this.allAnnotationProperties.size());
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }
}

