/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.bindingtree;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.coode.oppl.Variable;
import org.coode.oppl.bindingtree.Assignment;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.bindingtree.BindingVisitor;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;

public class LeafBrusher
implements BindingVisitor {
    private final Set<BindingNode> leaves = new HashSet<BindingNode>();
    private final Map<Variable<?>, Set<OWLObject>> bindings = new HashMap();

    public LeafBrusher(Map<Variable<?>, Set<OWLObject>> bindings) {
        this.bindings.putAll(ArgCheck.checkNotNull(bindings, "bindings"));
    }

    @Override
    public void visit(BindingNode bindingNode) {
        if (!bindingNode.isEmpty()) {
            HashSet<BindingNode> nodes = new HashSet<BindingNode>();
            nodes.add(bindingNode);
            boolean allLeaves = bindingNode.isLeaf();
            while (!allLeaves) {
                for (BindingNode generatedChild : new HashSet(nodes)) {
                    if (!generatedChild.isLeaf()) {
                        nodes.remove(generatedChild);
                        Set<BindingNode> generatedChildren = this.generateChildren(generatedChild);
                        nodes.addAll(generatedChildren);
                    }
                    allLeaves = this.allLeaves(nodes);
                }
            }
            this.leaves.addAll(nodes);
        }
    }

    private boolean allLeaves(Set<BindingNode> nodes) {
        Iterator<BindingNode> it = nodes.iterator();
        boolean allLeaves = true;
        while (allLeaves && it.hasNext()) {
            BindingNode generatedChild = it.next();
            allLeaves = generatedChild.isLeaf();
        }
        return allLeaves;
    }

    public Set<BindingNode> getLeaves() {
        return new HashSet<BindingNode>(this.leaves);
    }

    private Set<BindingNode> generateChildren(BindingNode node) {
        HashSet<BindingNode> toReturn = new HashSet<BindingNode>();
        if (node.isLeaf()) {
            toReturn.add(node);
            return toReturn;
        }
        Set<Variable<?>> unassignedVariables = node.getUnassignedVariables();
        for (Variable<?> variable : unassignedVariables) {
            Set<OWLObject> values = this.bindings.get(variable);
            if (values == null) continue;
            for (OWLObject owlObject : values) {
                if (owlObject instanceof OWLOntology) continue;
                Assignment extraAssignment = new Assignment(variable, owlObject);
                BindingNode newNode = new BindingNode(node.getAssignments(), unassignedVariables);
                newNode.addAssignment(extraAssignment);
                toReturn.add(newNode);
            }
        }
        return toReturn;
    }

    public Map<Variable<?>, Set<OWLObject>> getBindings() {
        return new HashMap(this.bindings);
    }
}

