/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl;

import java.util.HashMap;
import java.util.Map;
import org.coode.oppl.AbstractVariableScope;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.VariableScope;
import org.coode.oppl.VariableScopeChecker;
import org.coode.oppl.VariableScopes;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public class IndividualVariableScope
extends AbstractVariableScope<OWLClassExpression>
implements VariableScope<OWLClassExpression> {
    private static Map<OWLClassExpression, IndividualVariableScope> cache = new HashMap<OWLClassExpression, IndividualVariableScope>();
    private OWLClassExpression classExpression;

    IndividualVariableScope(OWLClassExpression classExpression, VariableScopeChecker checker) {
        super(checker);
        this.classExpression = classExpression;
    }

    static IndividualVariableScope buildIndividualVariableScope(OWLClassExpression classDescription, VariableScopeChecker checker) {
        IndividualVariableScope toReturn = cache.get(classDescription);
        if (toReturn == null) {
            toReturn = new IndividualVariableScope(classDescription, checker);
            cache.put(classDescription, toReturn);
        }
        return toReturn;
    }

    public OWLClassExpression getClassExpression() {
        return this.classExpression;
    }

    public void setDescription(OWLClassExpression classExpression) {
        this.classExpression = classExpression;
    }

    @Override
    public boolean check(OWLObject owlObject) throws OWLRuntimeException {
        return owlObject instanceof OWLIndividual && this.getChecker().check((OWLIndividual)owlObject, this);
    }

    @Override
    public VariableScopes.Direction getDirection() {
        return VariableScopes.Direction.INSTANCEOF;
    }

    @Override
    public OWLClassExpression getScopingObject() {
        return this.getClassExpression();
    }

    @Override
    public String render(ConstraintSystem constraintSystem) {
        ManchesterSyntaxRenderer renderer = constraintSystem.getOPPLFactory().getManchesterSyntaxRenderer(constraintSystem);
        this.getClassExpression().accept((OWLObjectVisitor)renderer);
        return String.format("[%s %s]", new Object[]{this.getDirection(), renderer});
    }
}

