/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.coode.oppl.OPPLAbstractFactory;
import org.coode.oppl.Variable;
import org.coode.oppl.VariableScope;
import org.coode.oppl.VariableVisitorEx;
import org.coode.oppl.bindingtree.Assignment;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.InvalidVariableNameException;
import org.coode.oppl.exceptions.OPPLException;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.Aggregandum;
import org.coode.oppl.function.Aggregation;
import org.coode.oppl.function.Create;
import org.coode.oppl.function.Expression;
import org.coode.oppl.function.OPPLFunction;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.generated.GeneratedVariable;
import org.coode.oppl.generated.RegexpGeneratedVariable;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.utils.VariableDetector;
import org.coode.oppl.utils.VariableExtractor;
import org.coode.oppl.utils.VariableRecogniser;
import org.coode.oppl.variabletypes.ANNOTATIONPROPERTYVariableType;
import org.coode.oppl.variabletypes.CLASSVariableType;
import org.coode.oppl.variabletypes.CONSTANTVariableType;
import org.coode.oppl.variabletypes.DATAPROPERTYVariableType;
import org.coode.oppl.variabletypes.INDIVIDUALVariableType;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.oppl.variabletypes.OBJECTPROPERTYVariableType;
import org.coode.oppl.variabletypes.VariableFactory;
import org.coode.oppl.variabletypes.VariableType;
import org.coode.oppl.variabletypes.VariableTypeFactory;
import org.coode.oppl.variabletypes.VariableTypeVisitorEx;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.OWLObjectVisitorExAdapter;

public class ConstraintSystem {
    private static final RightKindVisitor rightKindVisitor = new RightKindVisitor();
    public static final String VARIABLE_NAME_INVALID_CHARACTERS_REGEXP = "[[^\\?]&&[^\\p{Alnum}]&&[^-_]]";
    protected final VariableSet variables = new VariableSet();
    private final OWLOntology ontology;
    private Set<BindingNode> leaves = null;
    private OWLReasoner reasoner = null;
    private final OWLOntologyManager ontologyManager;
    private final OPPLAbstractFactory opplFactory;
    private final VariableDetector variableDetector = new VariableDetector(this);

    public ConstraintSystem(OWLOntology ontology, OWLOntologyManager ontologyManager, OPPLAbstractFactory opplFactory) {
        this.opplFactory = ArgCheck.checkNotNull(opplFactory, "ontology");
        this.ontology = ArgCheck.checkNotNull(ontology, "ontology manager");
        this.ontologyManager = ArgCheck.checkNotNull(ontologyManager, "OPPL factory");
    }

    public ConstraintSystem(OWLOntology ontology, OWLOntologyManager ontologyManager, OWLReasoner reasoner, OPPLAbstractFactory opplAbstractFactory) {
        this(ontology, ontologyManager, opplAbstractFactory);
        this.reasoner = reasoner;
    }

    public Variable<?> getVariable(String name) {
        return this.variables.get(name);
    }

    public <O extends OWLObject> InputVariable<O> createVariable(String name, VariableType<O> type, VariableScope<?> variableScope) throws OPPLException {
        if (name.matches("\\?([\\p{Alnum}[-_]])+")) {
            return this.createVariableWithVerifiedName(name, type, variableScope);
        }
        throw new InvalidVariableNameException("Invalid name: " + name);
    }

    public <O extends OWLObject> InputVariable<O> createVariableWithVerifiedName(final String name, final VariableType<O> type, final VariableScope<?> variableScope) throws OPPLException {
        Variable newVariable = this.variables.get(name);
        if (newVariable == null) {
            newVariable = type.getInputVariable(name, variableScope);
            this.variables.store(newVariable);
        } else {
            boolean rightKind = newVariable.accept(rightKindVisitor);
            if (!rightKind) {
                throw new OPPLException(String.format("A generated or regexp variable named %s already exists", name));
            }
            if (type != newVariable.getType()) {
                throw new OPPLException(String.format("An input variable named %s already exists but is of a different type %s from the input one %s", name, newVariable, type));
            }
            newVariable = (Variable)newVariable.accept(new VariableVisitorEx<Variable<?>>(){

                @Override
                public <P extends OWLObject> Variable<?> visit(InputVariable<P> v) {
                    InputVariable<Object> toReturn = v;
                    if (v.getVariableScope() != variableScope) {
                        toReturn = type.getInputVariable(name, variableScope);
                        ConstraintSystem.this.variables.store(toReturn);
                    }
                    return toReturn;
                }

                @Override
                public <P extends OWLObject> Variable<?> visit(GeneratedVariable<P> v) {
                    return v;
                }

                @Override
                public <P extends OWLObject> Variable<?> visit(RegexpGeneratedVariable<P> regExpGenerated) {
                    return regExpGenerated;
                }
            });
        }
        return (InputVariable)newVariable;
    }

    public Set<Variable<?>> getAxiomVariables(OWLAxiom axiom) {
        VariableExtractor axiomVariableExtractor = new VariableExtractor(this, true);
        Set<Variable<?>> axiomVariables = axiomVariableExtractor.extractVariables((OWLObject)axiom);
        return new HashSet(axiomVariables);
    }

    public boolean isVariableIRI(IRI iri) {
        return this.variables.containsVariableIRI(iri);
    }

    public Variable<?> getVariable(IRI iri) {
        return this.variables.get(iri);
    }

    public boolean isVariable(OWLObject e) {
        return (Boolean)e.accept((OWLObjectVisitorEx)this.variableDetector);
    }

    public void addLeaf(BindingNode bindingNode) {
        if (this.leaves == null) {
            this.leaves = new HashSet<BindingNode>();
        }
        this.leaves.add(bindingNode);
    }

    public Set<OWLObject> getVariableBindings(Variable<?> v, RuntimeExceptionHandler runtimeExceptionHandler) {
        HashSet<OWLObject> toReturn = new HashSet<OWLObject>();
        SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(this, BindingNode.getEmptyBindingNode(), runtimeExceptionHandler);
        if (this.leaves != null) {
            for (BindingNode bindingNode : this.leaves) {
                OWLObject assignmentValue = bindingNode.getAssignmentValue(v, parameters);
                if (assignmentValue == null) continue;
                toReturn.add(assignmentValue);
            }
        }
        return toReturn;
    }

    public boolean addLeaf(Variable<?> variable, OWLObject object) {
        boolean toReturn = variable.getType().isCompatibleWith(object);
        if (toReturn) {
            if (this.leaves == null) {
                this.leaves = new HashSet<BindingNode>();
            }
            Assignment assignment = new Assignment(variable, object);
            if (!this.leaves.isEmpty()) {
                for (BindingNode node : this.leaves) {
                    node.addAssignment(assignment);
                }
            } else {
                this.leaves.add(new BindingNode(assignment));
            }
        }
        return toReturn;
    }

    public Set<BindingNode> getLeaves() {
        return this.leaves == null ? this.leaves : new HashSet<BindingNode>(this.leaves);
    }

    public OPPLAbstractFactory getOPPLFactory() {
        return this.opplFactory;
    }

    public Set<InputVariable<?>> getInputVariables() {
        return this.variables.getInputVariables();
    }

    public void removeBinding(BindingNode binding) {
        this.leaves.remove(binding);
    }

    public boolean isVariable(OWLLiteral node) {
        return node.getLiteral().startsWith("?");
    }

    public void setLeaves(Collection<? extends BindingNode> newLeaves) {
        this.leaves = newLeaves == null ? null : new HashSet<BindingNode>(newLeaves);
    }

    public void setReasoner(OWLReasoner reasoner) {
        this.reasoner = reasoner;
    }

    public Set<Variable<?>> getVariables() {
        return this.variables.getAllVariables();
    }

    public OWLReasoner getReasoner() {
        return this.reasoner;
    }

    public <O extends OWLObject> GeneratedVariable<O> createStringGeneratedVariable(final String name, VariableType<O> type, final OPPLFunction<String> value) {
        GeneratedVariable generatedVariable = (GeneratedVariable)type.accept(new VariableTypeVisitorEx<GeneratedVariable<O>>(){

            @Override
            public GeneratedVariable<O> visitCLASSVariableType(CLASSVariableType t) {
                return VariableFactory.getGeneratedVariable(name, t, Create.createOWLClass(value));
            }

            @Override
            public GeneratedVariable<O> visitOBJECTPROPERTYVariableType(OBJECTPROPERTYVariableType t) {
                return VariableFactory.getGeneratedVariable(name, t, Create.createOWLObjectProperty(value));
            }

            @Override
            public GeneratedVariable<O> visitDATAPROPERTYVariableType(DATAPROPERTYVariableType t) {
                return VariableFactory.getGeneratedVariable(name, t, Create.createOWLDataProperty(value));
            }

            @Override
            public GeneratedVariable<O> visitINDIVIDUALVariableType(INDIVIDUALVariableType t) {
                return VariableFactory.getGeneratedVariable(name, t, Create.createOWLNamedIndividual(value));
            }

            @Override
            public GeneratedVariable<O> visitCONSTANTVariableType(CONSTANTVariableType t) {
                return VariableFactory.getGeneratedVariable(name, t, Create.createOWLLiteral(value));
            }

            @Override
            public GeneratedVariable<O> visitANNOTATIONPROPERTYVariableType(ANNOTATIONPROPERTYVariableType t) {
                return VariableFactory.getGeneratedVariable(name, t, Create.createOWLAnnotationProperty(value));
            }
        });
        this.variables.store(generatedVariable);
        return generatedVariable;
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public Set<GeneratedVariable<?>> getGeneratedVariables() {
        return this.variables.getGeneratedVariables();
    }

    public boolean isGenerated(Variable<?> v) {
        return this.variables.getGeneratedVariables().contains(v);
    }

    public void reset() {
        this.leaves = null;
    }

    public void removeVariable(Variable<?> variable) {
        this.variables.remove(variable.getName());
    }

    public GeneratedVariable<OWLClassExpression> createIntersectionGeneratedVariable(final String name, VariableType<?> type, Collection<? extends Aggregandum<Collection<? extends OWLClassExpression>>> operands) {
        OWLDataFactory df = this.getOntologyManager().getOWLDataFactory();
        final Aggregation<OWLClassExpression, Collection<OWLClassExpression>> and = Aggregation.buildClassExpressionIntersection(operands, df);
        GeneratedVariable<OWLClassExpression> toReturn = type.accept(new VariableTypeVisitorEx<GeneratedVariable<OWLClassExpression>>(){

            @Override
            public GeneratedVariable<OWLClassExpression> visitCLASSVariableType(CLASSVariableType t) {
                return VariableTypeFactory.getCLASSVariableType().getGeneratedVariable(name, and);
            }

            @Override
            public GeneratedVariable<OWLClassExpression> visitANNOTATIONPROPERTYVariableType(ANNOTATIONPROPERTYVariableType t) {
                return null;
            }

            @Override
            public GeneratedVariable<OWLClassExpression> visitOBJECTPROPERTYVariableType(OBJECTPROPERTYVariableType t) {
                return null;
            }

            @Override
            public GeneratedVariable<OWLClassExpression> visitDATAPROPERTYVariableType(DATAPROPERTYVariableType t) {
                return null;
            }

            @Override
            public GeneratedVariable<OWLClassExpression> visitINDIVIDUALVariableType(INDIVIDUALVariableType t) {
                return null;
            }

            @Override
            public GeneratedVariable<OWLClassExpression> visitCONSTANTVariableType(CONSTANTVariableType t) {
                return null;
            }
        });
        this.variables.store(toReturn);
        return toReturn;
    }

    public GeneratedVariable<OWLClassExpression> createUnionGeneratedVariable(final String name, VariableType<?> type, Collection<? extends Aggregandum<Collection<? extends OWLClassExpression>>> operands) {
        final Aggregation<OWLClassExpression, Collection<OWLClassExpression>> function = Aggregation.buildClassExpressionUnion(operands, this.getOntologyManager().getOWLDataFactory());
        GeneratedVariable<OWLClassExpression> toReturn = type.accept(new VariableTypeVisitorEx<GeneratedVariable<OWLClassExpression>>(){

            @Override
            public GeneratedVariable<OWLClassExpression> visitCLASSVariableType(CLASSVariableType t) {
                return VariableTypeFactory.getCLASSVariableType().getGeneratedVariable(name, function);
            }

            @Override
            public GeneratedVariable<OWLClassExpression> visitANNOTATIONPROPERTYVariableType(ANNOTATIONPROPERTYVariableType t) {
                return null;
            }

            @Override
            public GeneratedVariable<OWLClassExpression> visitOBJECTPROPERTYVariableType(OBJECTPROPERTYVariableType t) {
                return null;
            }

            @Override
            public GeneratedVariable<OWLClassExpression> visitDATAPROPERTYVariableType(DATAPROPERTYVariableType t) {
                return null;
            }

            @Override
            public GeneratedVariable<OWLClassExpression> visitINDIVIDUALVariableType(INDIVIDUALVariableType t) {
                return null;
            }

            @Override
            public GeneratedVariable<OWLClassExpression> visitCONSTANTVariableType(CONSTANTVariableType t) {
                return null;
            }
        });
        this.variables.store(toReturn);
        return toReturn;
    }

    public <O extends OWLObject> RegexpGeneratedVariable<? extends O> createRegexpGeneratedVariable(String name, VariableType<O> type, OPPLFunction<Pattern> patternGeneratingOPPLFunction) {
        RegexpGeneratedVariable<O> toReturn = type.getRegexpGeneratedVariable(name, patternGeneratingOPPLFunction);
        this.variables.store(toReturn);
        return toReturn;
    }

    public <O extends OWLObject> GeneratedVariable<O> createExpressionGeneratedVariable(final String name, O expression) {
        GeneratedVariable toReturn = (GeneratedVariable)expression.accept((OWLObjectVisitorEx)new OWLObjectVisitorExAdapter<GeneratedVariable<O>>(){

            protected GeneratedVariable<O> getDefaultReturnValue(OWLObject object) {
                return null;
            }

            public GeneratedVariable<O> visit(OWLClass desc) {
                return this.getCLASSGeneratedVariable(name, (OWLClassExpression)desc);
            }

            public GeneratedVariable<O> visit(OWLObjectIntersectionOf ce) {
                return this.getCLASSGeneratedVariable(name, (OWLClassExpression)ce);
            }

            public GeneratedVariable<O> visit(OWLObjectUnionOf ce) {
                return this.getCLASSGeneratedVariable(name, (OWLClassExpression)ce);
            }

            public GeneratedVariable<O> visit(OWLObjectComplementOf ce) {
                return this.getCLASSGeneratedVariable(name, (OWLClassExpression)ce);
            }

            public GeneratedVariable<O> visit(OWLObjectSomeValuesFrom ce) {
                return this.getCLASSGeneratedVariable(name, (OWLClassExpression)ce);
            }

            public GeneratedVariable<O> visit(OWLObjectAllValuesFrom ce) {
                return this.getCLASSGeneratedVariable(name, (OWLClassExpression)ce);
            }

            public GeneratedVariable<O> visit(OWLObjectHasValue ce) {
                return this.getCLASSGeneratedVariable(name, (OWLClassExpression)ce);
            }

            public GeneratedVariable<O> visit(OWLObjectMinCardinality ce) {
                return this.getCLASSGeneratedVariable(name, (OWLClassExpression)ce);
            }

            public GeneratedVariable<O> visit(OWLObjectExactCardinality ce) {
                return this.getCLASSGeneratedVariable(name, (OWLClassExpression)ce);
            }

            public GeneratedVariable<O> visit(OWLObjectMaxCardinality ce) {
                return this.getCLASSGeneratedVariable(name, (OWLClassExpression)ce);
            }

            public GeneratedVariable<O> visit(OWLObjectHasSelf ce) {
                return this.getCLASSGeneratedVariable(name, (OWLClassExpression)ce);
            }

            public GeneratedVariable<O> visit(OWLObjectOneOf ce) {
                return this.getCLASSGeneratedVariable(name, (OWLClassExpression)ce);
            }

            public GeneratedVariable<O> visit(OWLDataSomeValuesFrom ce) {
                return this.getCLASSGeneratedVariable(name, (OWLClassExpression)ce);
            }

            public GeneratedVariable<O> visit(OWLDataAllValuesFrom ce) {
                return this.getCLASSGeneratedVariable(name, (OWLClassExpression)ce);
            }

            public GeneratedVariable<O> visit(OWLDataHasValue ce) {
                return this.getCLASSGeneratedVariable(name, (OWLClassExpression)ce);
            }

            public GeneratedVariable<O> visit(OWLDataMinCardinality ce) {
                return this.getCLASSGeneratedVariable(name, (OWLClassExpression)ce);
            }

            public GeneratedVariable<O> visit(OWLDataExactCardinality ce) {
                return this.getCLASSGeneratedVariable(name, (OWLClassExpression)ce);
            }

            public GeneratedVariable<O> visit(OWLDataMaxCardinality ce) {
                return this.getCLASSGeneratedVariable(name, (OWLClassExpression)ce);
            }

            public GeneratedVariable<O> visit(OWLObjectProperty property) {
                return this.getOBJECTPROPERTYGeneratedVariable(name, (OWLObjectPropertyExpression)property);
            }

            public GeneratedVariable<O> visit(OWLObjectInverseOf property) {
                return this.getOBJECTPROPERTYGeneratedVariable(name, (OWLObjectPropertyExpression)property);
            }

            protected GeneratedVariable<O> getCLASSGeneratedVariable(String varName, OWLClassExpression desc) {
                return VariableTypeFactory.getCLASSVariableType().getGeneratedVariable(varName, new Expression<OWLClassExpression>(desc));
            }

            protected GeneratedVariable<O> getOBJECTPROPERTYGeneratedVariable(String varName, OWLObjectPropertyExpression p) {
                return VariableTypeFactory.getOBJECTPROPERTYTypeVariableType().getGeneratedVariable(varName, new Expression<OWLObjectPropertyExpression>(p));
            }
        });
        this.variables.store(toReturn);
        return toReturn;
    }

    public String render(Variable<?> variable) {
        return variable.getName();
    }

    public void importVariable(Variable<?> v) {
        this.variables.store(v);
    }

    public void clearVariables() {
        this.variables.clear();
    }

    public OWLOntologyManager getOntologyManager() {
        return this.ontologyManager;
    }

    private static final class VariableSet {
        private final Map<String, Variable<?>> map = new HashMap();
        private final Map<IRI, Variable<?>> irisMap = new HashMap();

        public Variable<?> get(String name) {
            return this.map.get(name);
        }

        public Variable<?> get(IRI variableIRI) {
            return this.irisMap.get(variableIRI);
        }

        public void store(Variable<?> variable) {
            this.map.put(variable.getName(), variable);
            this.irisMap.put(variable.getIRI(), variable);
        }

        public boolean containsVariableIRI(IRI variableURI) {
            return this.irisMap.containsKey(variableURI);
        }

        public Set<InputVariable<?>> getInputVariables() {
            HashSet toReturn = new HashSet(this.map.values().size());
            for (Variable<?> v : this.map.values()) {
                if (!VariableRecogniser.INPUT_VARIABLE_RECOGNISER.recognise(v)) continue;
                toReturn.add((InputVariable)v);
            }
            return toReturn;
        }

        public Set<Variable<?>> getAllVariables() {
            return new HashSet(this.map.values());
        }

        public Set<GeneratedVariable<?>> getGeneratedVariables() {
            HashSet toReturn = new HashSet(this.map.values().size());
            for (Variable<?> v : this.map.values()) {
                if (!VariableRecogniser.GENERATED_VARIABLE_RECOGNISER.recognise(v)) continue;
                toReturn.add((GeneratedVariable)v);
            }
            return toReturn;
        }

        public void remove(String name) {
            Variable<?> removed = this.map.remove(name);
            if (removed != null) {
                this.irisMap.remove(removed.getIRI());
            }
        }

        public void clear() {
            this.map.clear();
            this.irisMap.clear();
        }

        public String toString() {
            Set<GeneratedVariable<?>> generatedVariables = this.getGeneratedVariables();
            StringBuilder b = new StringBuilder();
            for (Variable<?> variable : this.map.values()) {
                b.append(String.format("Variable name: %s generated: %s \n", variable.getName(), generatedVariables.contains(variable)));
            }
            return b.toString();
        }
    }

    private static final class RightKindVisitor
    implements VariableVisitorEx<Boolean> {
        @Override
        public <P extends OWLObject> Boolean visit(InputVariable<P> v) {
            return true;
        }

        @Override
        public <P extends OWLObject> Boolean visit(GeneratedVariable<P> v) {
            return false;
        }

        @Override
        public <P extends OWLObject> Boolean visit(RegexpGeneratedVariable<P> regExpGenerated) {
            return false;
        }
    }
}

