/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.BidirectionalShortFormProviderAdapter;
import org.coode.parsers.DisposableShortFormEntityChecker;
import org.coode.parsers.EntityFinderImpl;
import org.coode.parsers.OWLEntityRenderingCacheImpl;
import org.coode.parsers.ShortFormEntityRenderer;
import org.coode.parsers.factory.SymbolTableFactory;
import org.coode.parsers.oppl.OPPLScope;
import org.coode.parsers.oppl.OPPLSymbolTable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.util.AnnotationValueShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class AnnotationBasedSymbolTableFactory
implements SymbolTableFactory<OPPLSymbolTable> {
    private final OWLOntologyManager manager;
    private final List<OWLAnnotationProperty> annotations = new ArrayList<OWLAnnotationProperty>();

    public AnnotationBasedSymbolTableFactory(OWLOntologyManager manager, List<? extends IRI> iris) {
        this.manager = ArgCheck.checkNotNull(manager, "The ontology manager");
        OWLDataFactory dataFactory = this.manager.getOWLDataFactory();
        for (IRI iRI : ArgCheck.checkNotNull(iris, "The iri list")) {
            this.annotations.add(dataFactory.getOWLAnnotationProperty(iRI));
        }
    }

    @Override
    public OPPLSymbolTable createSymbolTable() {
        AnnotationValueShortFormProvider baseShortFormProvider = new AnnotationValueShortFormProvider(this.annotations, Collections.emptyMap(), (OWLOntologySetProvider)this.manager);
        BidirectionalShortFormProviderAdapter shortFormProvider = new BidirectionalShortFormProviderAdapter(this.manager, this.manager.getOntologies(), (ShortFormProvider)baseShortFormProvider);
        DisposableShortFormEntityChecker entityChecker = new DisposableShortFormEntityChecker(shortFormProvider);
        ShortFormEntityRenderer entityRenderer = new ShortFormEntityRenderer((ShortFormProvider)baseShortFormProvider);
        EntityFinderImpl entityFinder = new EntityFinderImpl(this.manager, new OWLEntityRenderingCacheImpl(this.manager, entityRenderer), false);
        return new OPPLSymbolTable(new OPPLScope(entityChecker, entityFinder, entityRenderer), this.manager.getOWLDataFactory());
    }
}

