/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.ui.autocompletionmatcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.ui.autocompletionmatcher.AutoCompletionMatcher;

public final class KeywordAutoCompletionMatcher
implements AutoCompletionMatcher {
    private final Set<String> keywords = new HashSet<String>();

    public KeywordAutoCompletionMatcher(Collection<? extends String> keywords) {
        this.keywords.addAll(ArgCheck.checkNotNull(keywords, "keywords"));
    }

    @Override
    public List<String> getMatches(String string2Complete) {
        ArrayList<String> toReturn = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\A" + string2Complete + ".*", 2);
        for (String kw : this.keywords) {
            Matcher matcher = pattern.matcher(kw);
            if (!matcher.matches()) continue;
            toReturn.add(kw);
        }
        Collections.sort(toReturn);
        return toReturn;
    }
}

