/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.net.URI;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonErrorNode;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.RewriteEmptyStreamException;
import org.antlr.runtime.tree.TreeAdaptor;
import org.antlr.runtime.tree.TreeNodeStream;
import org.coode.oppl.OPPLShortFormProvider;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.ErrorListener;
import org.coode.parsers.MOWLLexer;
import org.coode.parsers.ManchesterOWLSyntaxParser;
import org.coode.parsers.ManchesterOWLSyntaxSimplify;
import org.coode.parsers.ManchesterOWLSyntaxTree;
import org.coode.parsers.ManchesterOWLSyntaxTypes;
import org.coode.parsers.ShortFormEntityRenderer;
import org.coode.parsers.SymbolTable;
import org.coode.parsers.Type;
import org.coode.parsers.factory.SimpleSymbolTableFactory;
import org.coode.parsers.factory.SymbolTableFactory;
import org.coode.parsers.ui.AbstractLinearisingErrorReport;
import org.coode.parsers.ui.AutoCompleter;
import org.coode.parsers.ui.ErrorReport;
import org.coode.parsers.ui.ExpressionChecker;
import org.coode.parsers.ui.ExpressionEditor;
import org.coode.parsers.ui.autocompletionmatcher.ManchesterOWLSyntaxSimpleAutoCompletionMatcher;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.util.OWLObjectVisitorExAdapter;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;

public class ManchesterOWLSyntaxValidatorGUI
extends JFrame {
    private static final long serialVersionUID = 20100L;
    protected final OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    protected final SymbolTableFactory<SymbolTable> symbolTableFactory = new SimpleSymbolTableFactory(this.manager);
    private final ExpressionChecker<OWLAxiom> checker = new AxiomChecker();
    protected final ExpressionEditor<OWLAxiom> axiomValidator = new ExpressionEditor<OWLAxiom>(this.manager, this.checker);

    public void loadOntology(URI uri) {
        try {
            this.manager.loadOntology(IRI.create((URI)uri));
        }
        catch (OWLOntologyCreationException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error in loading ontology", 0);
        }
    }

    @Override
    public String getName() {
        return "Syntax validator";
    }

    public ManchesterOWLSyntaxValidatorGUI() {
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.setTitle(this.getName());
        this.axiomValidator.setPreferredSize(new Dimension(400, 300));
        this.add(this.axiomValidator, "Center");
    }

    public static void main(String[] args) {
        ManchesterOWLSyntaxValidatorGUI frame = new ManchesterOWLSyntaxValidatorGUI();
        frame.setDefaultCloseOperation(3);
        frame.pack();
        for (String string : args) {
            frame.loadOntology(URI.create(string));
        }
        frame.setVisible(true);
    }

    private final class AxiomChecker
    implements ExpressionChecker<OWLAxiom> {
        protected final AxiomCheckerErrorListener listener = new AxiomCheckerErrorListener();
        protected ErrorReport lastReport = null;
        private OWLAxiom lastObject = null;
        private final TreeAdaptor adaptor = new CommonTreeAdaptor(){

            public Object create(Token token) {
                return new ManchesterOWLSyntaxTree(token);
            }

            public Object dupNode(Object t) {
                if (t == null) {
                    return null;
                }
                return this.create(((ManchesterOWLSyntaxTree)((Object)t)).token);
            }

            public Object errorNode(TokenStream input, Token start, Token stop, RecognitionException e) {
                return new CommonErrorNode(input, start, stop, e);
            }
        };
        private ManchesterOWLSyntaxTree parsed;
        private SymbolTable symbolTable;
        private AutoCompleter autoCompleter = null;

        @Override
        public void check(String text) {
            this.reset();
            this.parsed = this.parse(text);
            this.lastObject = this.parsed == null || this.parsed.getOWLObject() == null ? null : (OWLAxiom)this.parsed.getOWLObject().accept((OWLObjectVisitorEx)new OWLObjectVisitorExAdapter<OWLAxiom>(){

                protected OWLAxiom getDefaultReturnValue(OWLObject object) {
                    AxiomChecker.this.lastReport = new ErrorReportImpl("Wrong kind of owl object parsed " + object.getClass().getName(), 0, 0, 0);
                    return (OWLAxiom)super.getDefaultReturnValue(object);
                }

                public OWLAxiom visit(OWLSubClassOfAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLAsymmetricObjectPropertyAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLReflexiveObjectPropertyAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLDisjointClassesAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLDataPropertyDomainAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLObjectPropertyDomainAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLEquivalentObjectPropertiesAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLDifferentIndividualsAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLDisjointObjectPropertiesAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLObjectPropertyRangeAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLObjectPropertyAssertionAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLFunctionalObjectPropertyAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLSubObjectPropertyOfAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLDisjointUnionAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLDeclarationAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLSymmetricObjectPropertyAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLDataPropertyRangeAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLFunctionalDataPropertyAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLEquivalentDataPropertiesAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLClassAssertionAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLEquivalentClassesAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLDataPropertyAssertionAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLTransitiveObjectPropertyAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLSubDataPropertyOfAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLSameIndividualAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLSubPropertyChainOfAxiom axiom) {
                    return axiom;
                }

                public OWLAxiom visit(OWLInverseObjectPropertiesAxiom axiom) {
                    return axiom;
                }
            });
        }

        private void reset() {
            this.lastObject = null;
            this.lastReport = null;
            this.parsed = null;
            this.listener.clear();
            this.symbolTable = ManchesterOWLSyntaxValidatorGUI.this.symbolTableFactory.createSymbolTable();
            if (this.autoCompleter == null) {
                ManchesterOWLSyntaxSimpleAutoCompletionMatcher matcher = new ManchesterOWLSyntaxSimpleAutoCompletionMatcher(new ShortFormEntityRenderer(new OPPLShortFormProvider((ShortFormProvider)new SimpleShortFormProvider())), ManchesterOWLSyntaxValidatorGUI.this.manager);
                this.autoCompleter = new AutoCompleter(ManchesterOWLSyntaxValidatorGUI.this.axiomValidator, matcher);
            }
        }

        @Override
        public OWLAxiom createObject(String text) {
            return this.lastObject;
        }

        @Override
        public ErrorReport getErrorReport() {
            return this.lastReport;
        }

        protected ManchesterOWLSyntaxTree parse(String input) {
            MOWLLexer lexer = new MOWLLexer((CharStream)new ANTLRStringStream(input));
            TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lexer);
            ManchesterOWLSyntaxParser parser = new ManchesterOWLSyntaxParser((TokenStream)tokens, this.listener);
            parser.setTreeAdaptor(this.adaptor);
            ManchesterOWLSyntaxParser.main_return r = parser.main();
            CommonTree tree = (CommonTree)r.getTree();
            if (tree != null) {
                CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)tree);
                nodes.setTokenStream((TokenStream)tokens);
                nodes.setTreeAdaptor(this.adaptor);
                this.symbolTable.setErrorListener(this.listener);
                ManchesterOWLSyntaxSimplify simplify = new ManchesterOWLSyntaxSimplify((TreeNodeStream)nodes);
                simplify.setTreeAdaptor(this.adaptor);
                simplify.downup(tree);
                nodes.reset();
                ManchesterOWLSyntaxTypes typeComp = new ManchesterOWLSyntaxTypes((TreeNodeStream)nodes, this.symbolTable, this.listener);
                typeComp.downup(tree);
            }
            return (ManchesterOWLSyntaxTree)tree;
        }

        private final class ErrorReportImpl
        extends AbstractLinearisingErrorReport {
            private final String message;
            private final int charPositionInLine;
            private final int line;
            private final int length;

            public ErrorReportImpl(String message, int line, int charPositionInline, int length) {
                this.message = ArgCheck.checkNotNull(message, "message");
                this.charPositionInLine = charPositionInline;
                this.line = line;
                this.length = length;
            }

            @Override
            public String getMessage() {
                return this.message;
            }

            @Override
            public int getCharPositionInLine() {
                return this.charPositionInLine;
            }

            @Override
            public int getLine() {
                return this.line;
            }

            @Override
            public int getLength() {
                return this.length;
            }
        }

        private final class AxiomCheckerErrorListener
        implements ErrorListener {
            private CommonTree lastErrorTree = null;

            public void clear() {
                this.lastErrorTree = null;
            }

            boolean isRedundant(CommonTree possibleParent, CommonTree newErrorTree) {
                boolean b;
                if (possibleParent == null) {
                    return false;
                }
                boolean bl = b = possibleParent == newErrorTree || newErrorTree.equals(possibleParent);
                if (!b) {
                    boolean bl2 = b = possibleParent.parent == newErrorTree;
                    if (!b) {
                        b = this.isRedundant(possibleParent.parent, newErrorTree);
                    }
                }
                return b;
            }

            @Override
            public void reportThrowable(Throwable t, int line, int charPosInLine, int length) {
                AxiomChecker.this.lastReport = new ErrorReportImpl(t.getMessage(), line, charPosInLine, length);
            }

            boolean isRedundant(CommonTree newErrorTree) {
                return this.isRedundant(this.lastErrorTree, newErrorTree);
            }

            @Override
            public void unrecognisedSymbol(CommonTree t) {
                this.lastErrorTree = t;
                AxiomChecker.this.lastReport = new ErrorReportImpl("Unrecognised token " + t.getText(), t.getLine(), t.getCharPositionInLine(), t.getText().length());
            }

            @Override
            public void recognitionException(RecognitionException e) {
                String message = e.getMessage() == null ? ((Object)((Object)e)).getClass().getName() : e.getMessage();
                int endIndex = e.token.getText() == null ? 0 : e.token.getText().length();
                AxiomChecker.this.lastReport = new ErrorReportImpl(message + " on token " + e.token, e.line, e.charPositionInLine, endIndex);
            }

            @Override
            public void recognitionException(RecognitionException e, String ... tokenNames) {
                String message = "Recognition exception on the token " + e.token + ((Object)((Object)e)).getClass().getSimpleName();
                int endIndex = e.token.getText() == null ? 0 : e.token.getText().length();
                AxiomChecker.this.lastReport = new ErrorReportImpl(message, e.line, e.charPositionInLine, endIndex);
            }

            @Override
            public void rewriteEmptyStreamException(RewriteEmptyStreamException e) {
                AxiomChecker.this.lastReport = new ErrorReportImpl("Incomplete input ", 0, 0, 0);
            }

            @Override
            public void incompatibleSymbols(CommonTree parentExpression, CommonTree ... expressions) {
                StringBuilder builder = new StringBuilder();
                builder.append("[");
                boolean first = true;
                for (CommonTree expression : expressions) {
                    String comma = first ? "" : ", ";
                    first = false;
                    builder.append(comma);
                    builder.append(expression.getText() == null ? "" : expression.getText());
                }
                builder.append("]");
                AxiomChecker.this.lastReport = new ErrorReportImpl("Incompatible children expressions: " + builder.toString() + " for the parent expression  " + parentExpression.getText(), parentExpression.getLine(), parentExpression.getCharPositionInLine(), parentExpression.getText().length());
            }

            @Override
            public void incompatibleSymbolType(CommonTree t, Type type, CommonTree expression) {
                if (!this.isRedundant(t)) {
                    this.lastErrorTree = t;
                    AxiomChecker.this.lastReport = new ErrorReportImpl("Incompatible type: " + type + "  for token: " + t.getText() + " for the parent expression " + expression.getText(), t.getLine(), t.getCharPositionInLine(), t.getText().length());
                }
            }

            @Override
            public void illegalToken(CommonTree t, String message) {
                AxiomChecker.this.lastReport = new ErrorReportImpl("Illegal token: " + t.getText(), t.getLine(), t.getCharPositionInLine(), t.getText().length());
            }
        }
    }
}

