/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.variabletypes;

import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.Variable;
import org.coode.oppl.VariableScope;
import org.coode.oppl.VariableVisitor;
import org.coode.oppl.VariableVisitorEx;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.variabletypes.VariableType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLObject;

public class InputVariable<O extends OWLObject>
implements Variable<O> {
    private final String name;
    private final VariableType<O> type;
    private final IRI iri;
    private final VariableScope<?> variableScope;

    InputVariable(String name, VariableType<O> type) {
        this(name, type, null);
    }

    InputVariable(String name, VariableType<O> type, VariableScope<?> variableScope) {
        this.name = ArgCheck.checkNotNull(name, "name");
        this.type = ArgCheck.checkNotNull(type, "type");
        this.iri = IRI.create((String)"http://www.coode.org/oppl/variablemansyntax#", (String)name);
        this.variableScope = variableScope;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    @Override
    public VariableType<O> getType() {
        return this.type;
    }

    public String toString() {
        return this.name + ":" + this.getType();
    }

    public VariableScope<?> getVariableScope() {
        return this.variableScope;
    }

    @Override
    public <T> T accept(VariableVisitorEx<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(VariableVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int prime = 907;
        int result = 1;
        result = 907 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InputVariable other = (InputVariable)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public String render(ConstraintSystem constraintSystem) {
        String scope = this.getVariableScope() == null ? "" : this.getVariableScope().render(constraintSystem);
        return String.format("%s:%s%s", this.getName(), this.getType(), scope);
    }

    static <P extends OWLObject> InputVariable<P> getInputVariable(String name, VariableType<P> type, VariableScope<?> variableScope) {
        return new InputVariable<P>(name, type, variableScope);
    }
}

