/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.variabletypes;

import java.util.Collection;
import java.util.EnumSet;
import org.coode.oppl.VariableScope;
import org.coode.oppl.VariableScopes;
import org.coode.oppl.function.OPPLFunction;
import org.coode.oppl.generated.GeneratedVariable;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.oppl.variabletypes.VariableType;
import org.coode.oppl.variabletypes.VariableTypeName;
import org.semanticweb.owlapi.model.OWLObject;

abstract class AbstractVariableType<O extends OWLObject>
implements VariableType<O> {
    private final VariableTypeName name;
    private final EnumSet<VariableScopes.Direction> allowedDirections = EnumSet.noneOf(VariableScopes.Direction.class);

    public AbstractVariableType(VariableTypeName name, EnumSet<VariableScopes.Direction> allowedDirections) {
        this.name = ArgCheck.checkNotNull(name, "name");
        this.allowedDirections.addAll((Collection<VariableScopes.Direction>)ArgCheck.checkNotNull(allowedDirections, "allowedDirections"));
    }

    public VariableTypeName getName() {
        return this.name;
    }

    @Override
    public EnumSet<VariableScopes.Direction> getAllowedDirections() {
        return EnumSet.copyOf(this.allowedDirections);
    }

    public String toString() {
        return this.getName().toString();
    }

    @Override
    public InputVariable<O> getInputVariable(String n, VariableScope<?> variableScope) {
        return InputVariable.getInputVariable(n, this, variableScope);
    }

    @Override
    public GeneratedVariable<O> getGeneratedVariable(String n, OPPLFunction<? extends O> opplFunction) {
        return GeneratedVariable.getGeneratedVariable(n, this, opplFunction);
    }
}

