/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.utils;

import java.util.ArrayList;
import java.util.List;

public class PrimeNumbersUtils {
    public static List<Integer> getNPrimes(int n) {
        boolean enough;
        if (n < 0) {
            throw new IllegalArgumentException("The input n must be >=0, it is in fact:  " + n);
        }
        int upperBound = n * 10;
        List<Integer> primes = PrimeNumbersUtils.runEratosthenesSieve(upperBound);
        boolean bl = enough = primes.size() >= n;
        while (!enough) {
            enough = (primes = PrimeNumbersUtils.runEratosthenesSieve(upperBound += upperBound)).size() >= n;
        }
        return primes.subList(0, n);
    }

    public static List<Integer> runEratosthenesSieve(int upperBound) {
        int m;
        int upperBoundSquareRoot = (int)Math.sqrt(upperBound);
        ArrayList<Integer> toReturn = new ArrayList<Integer>(upperBound / 2);
        boolean[] isComposite = new boolean[upperBound + 1];
        for (m = 2; m <= upperBoundSquareRoot; ++m) {
            if (isComposite[m]) continue;
            for (int k = m * m; k <= upperBound; k += m) {
                isComposite[k] = true;
            }
        }
        for (m = 1; m <= upperBound; ++m) {
            if (isComposite[m]) continue;
            toReturn.add(m);
        }
        return toReturn;
    }

    public static int getNextPrime(int n) {
        int toReturn = n + 1;
        boolean found = PrimeNumbersUtils.isPrime(toReturn);
        while (!found) {
            found = PrimeNumbersUtils.isPrime(++toReturn);
        }
        return toReturn;
    }

    public static boolean isPrime(int n) {
        return PrimeNumbersUtils.millerRabin32(n);
    }

    private static boolean millerRabinPass32(int a, int n) {
        int s;
        int a_to_power;
        int d = n - 1;
        if ((a_to_power = PrimeNumbersUtils.modularExponent32(a, d >>= (s = Integer.numberOfTrailingZeros(d)), n)) == 1) {
            return true;
        }
        for (int i = 0; i < s - 1; ++i) {
            if (a_to_power == n - 1) {
                return true;
            }
            a_to_power = PrimeNumbersUtils.modularExponent32(a_to_power, 2, n);
        }
        return a_to_power == n - 1;
    }

    private static int modularExponent32(int base, int power, int modulus) {
        long result = 1L;
        for (int i = 31; i >= 0; --i) {
            result = result * result % (long)modulus;
            if ((power & 1 << i) == 0) continue;
            result = result * (long)base % (long)modulus;
        }
        return (int)result;
    }

    public static boolean millerRabin32(int n) {
        if (n <= 1) {
            return false;
        }
        if (n == 2) {
            return true;
        }
        return !(!PrimeNumbersUtils.millerRabinPass32(2, n) || n > 7 && !PrimeNumbersUtils.millerRabinPass32(7, n) || n > 61 && !PrimeNumbersUtils.millerRabinPass32(61, n));
    }
}

