/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.semanticweb.owlapi.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.coode.oppl.semanticweb.owlapi.model.OWLPropertyChain;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;

public class OWLPropertyChainImpl
implements OWLPropertyChain {
    private static final long serialVersionUID = 20100L;
    private final List<OWLObjectPropertyExpression> delegate = new ArrayList<OWLObjectPropertyExpression>();

    public OWLPropertyChainImpl(List<? extends OWLObjectPropertyExpression> delegate) {
        this.delegate.addAll((Collection<OWLObjectPropertyExpression>)ArgCheck.checkNotNull(delegate, "delegate"));
        if (delegate.size() < 2) {
            throw new IllegalArgumentException("The list cannot have less than 2 elements");
        }
    }

    @Override
    public void add(int index, OWLObjectPropertyExpression element) {
        this.delegate.add(index, element);
    }

    @Override
    public boolean add(OWLObjectPropertyExpression e) {
        return this.delegate.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends OWLObjectPropertyExpression> c) {
        return this.delegate.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends OWLObjectPropertyExpression> c) {
        return this.delegate.addAll(index, c);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public OWLObjectPropertyExpression get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<OWLObjectPropertyExpression> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public ListIterator<OWLObjectPropertyExpression> listIterator() {
        return this.delegate.listIterator();
    }

    @Override
    public ListIterator<OWLObjectPropertyExpression> listIterator(int index) {
        return this.delegate.listIterator(index);
    }

    @Override
    public OWLObjectPropertyExpression remove(int index) {
        return this.delegate.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public OWLObjectPropertyExpression set(int index, OWLObjectPropertyExpression element) {
        return this.delegate.set(index, element);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public List<OWLObjectPropertyExpression> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    public void accept(OWLObjectVisitor visitor) {
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return null;
    }

    public int compareTo(OWLObject o) {
        return 1;
    }

    public Set<OWLEntity> getSignature() {
        HashSet<OWLEntity> toReturn = new HashSet<OWLEntity>();
        for (OWLObjectPropertyExpression propertyExpression : this.delegate) {
            toReturn.addAll(propertyExpression.getSignature());
        }
        return toReturn;
    }

    public boolean containsEntityInSignature(OWLEntity owlEntity) {
        for (OWLObjectPropertyExpression e : this.delegate) {
            if (!e.containsEntityInSignature(owlEntity)) continue;
            return true;
        }
        return false;
    }

    public Set<OWLClass> getClassesInSignature() {
        return Collections.emptySet();
    }

    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    public Set<OWLDatatype> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        HashSet<OWLObjectProperty> toReturn = new HashSet<OWLObjectProperty>();
        for (OWLObjectPropertyExpression propertyExpression : this.delegate) {
            toReturn.addAll(propertyExpression.getObjectPropertiesInSignature());
        }
        return toReturn;
    }

    public Set<OWLClassExpression> getNestedClassExpressions() {
        return Collections.emptySet();
    }

    public boolean isBottomEntity() {
        return false;
    }

    public boolean isTopEntity() {
        return false;
    }

    public Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        return Collections.emptySet();
    }
}

