/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.search.solvability;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.coode.oppl.search.solvability.QuerySolver;
import org.coode.oppl.utils.ArgCheck;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public final class AssertedModelQuerySolver
implements QuerySolver {
    private final OWLOntologyManager ontologyManager;

    public AssertedModelQuerySolver(OWLOntologyManager ontologyManager) {
        this.ontologyManager = ArgCheck.checkNotNull(ontologyManager, "ontologyManager");
    }

    @Override
    public Set<OWLClass> getSubClasses(OWLClassExpression superClass) {
        HashSet<OWLClass> toReturn = new HashSet<OWLClass>();
        for (OWLOntology ontology : this.ontologyManager.getOntologies()) {
            for (OWLSubClassOfAxiom owlAxiom : ontology.getAxioms(AxiomType.SUBCLASS_OF)) {
                if (!owlAxiom.getSuperClass().equals(superClass) || owlAxiom.getSubClass().isAnonymous()) continue;
                toReturn.add(owlAxiom.getSubClass().asOWLClass());
            }
        }
        return toReturn;
    }

    @Override
    public Set<OWLClass> getSuperClasses(OWLClassExpression subClass) {
        HashSet<OWLClass> toReturn = new HashSet<OWLClass>();
        for (OWLOntology ontology : this.ontologyManager.getOntologies()) {
            for (OWLSubClassOfAxiom owlAxiom : ontology.getAxioms(AxiomType.SUBCLASS_OF)) {
                if (!owlAxiom.getSubClass().equals(subClass) || owlAxiom.getSuperClass().isAnonymous()) continue;
                toReturn.add(owlAxiom.getSuperClass().asOWLClass());
            }
        }
        return toReturn;
    }

    @Override
    public Set<OWLNamedIndividual> getNamedFillers(OWLNamedIndividual subject, OWLObjectPropertyExpression objectProperty) {
        HashSet<OWLNamedIndividual> toReturn = new HashSet<OWLNamedIndividual>();
        for (OWLOntology ontology : this.ontologyManager.getOntologies()) {
            for (OWLObjectPropertyAssertionAxiom owlAxiom : ontology.getAxioms(AxiomType.OBJECT_PROPERTY_ASSERTION)) {
                if (!owlAxiom.getSubject().equals(subject) || !((OWLObjectPropertyExpression)owlAxiom.getProperty()).equals(objectProperty) || ((OWLIndividual)owlAxiom.getObject()).isAnonymous()) continue;
                toReturn.add(((OWLIndividual)owlAxiom.getObject()).asOWLNamedIndividual());
            }
        }
        return toReturn;
    }

    @Override
    public boolean hasNoSubClass(OWLClassExpression superClass) {
        boolean found = false;
        Iterator ontologyIterator = this.ontologyManager.getOntologies().iterator();
        while (!found && ontologyIterator.hasNext()) {
            OWLOntology owlOntology = (OWLOntology)ontologyIterator.next();
            Iterator iterator = owlOntology.getAxioms(AxiomType.SUBCLASS_OF).iterator();
            while (!found && iterator.hasNext()) {
                OWLSubClassOfAxiom owlSubClassOfAxiom = (OWLSubClassOfAxiom)iterator.next();
                found = owlSubClassOfAxiom.getSuperClass().equals(superClass);
            }
        }
        return !found;
    }

    @Override
    public boolean hasNoSuperClass(OWLClassExpression subClass) {
        boolean found = false;
        Iterator ontologyIterator = this.ontologyManager.getOntologies().iterator();
        while (!found && ontologyIterator.hasNext()) {
            OWLOntology owlOntology = (OWLOntology)ontologyIterator.next();
            Iterator iterator = owlOntology.getAxioms(AxiomType.SUBCLASS_OF).iterator();
            while (!found && iterator.hasNext()) {
                OWLSubClassOfAxiom owlSubClassOfAxiom = (OWLSubClassOfAxiom)iterator.next();
                found = owlSubClassOfAxiom.getSubClass().equals(subClass);
            }
        }
        return !found;
    }
}

