/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.search.solvability;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.PartialOWLObjectInstantiator;
import org.coode.oppl.Variable;
import org.coode.oppl.VariableScope;
import org.coode.oppl.VariableVisitorEx;
import org.coode.oppl.bindingtree.Assignment;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.generated.GeneratedVariable;
import org.coode.oppl.generated.RegexpGeneratedVariable;
import org.coode.oppl.log.Logging;
import org.coode.oppl.queryplanner.ConstantExtractor;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.coode.oppl.search.AssignableValueExtractor;
import org.coode.oppl.search.SearchTree;
import org.coode.oppl.search.solvability.AxiomSolvability;
import org.coode.oppl.search.solvability.NoSolutionSolvableSearchNode;
import org.coode.oppl.search.solvability.SolvabilitySearchNode;
import org.coode.oppl.search.solvability.SolvabilitySearchNodeVisitorEx;
import org.coode.oppl.search.solvability.SolvableSearchNode;
import org.coode.oppl.search.solvability.SolvedSearchNode;
import org.coode.oppl.search.solvability.UnsolvableSearchNode;
import org.coode.oppl.utils.AbstractVariableVisitorExAdapter;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.utils.VariableExtractor;
import org.coode.oppl.variabletypes.ANNOTATIONPROPERTYVariableType;
import org.coode.oppl.variabletypes.CLASSVariableType;
import org.coode.oppl.variabletypes.CONSTANTVariableType;
import org.coode.oppl.variabletypes.DATAPROPERTYVariableType;
import org.coode.oppl.variabletypes.INDIVIDUALVariableType;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.oppl.variabletypes.OBJECTPROPERTYVariableType;
import org.coode.oppl.variabletypes.VariableTypeVisitorEx;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;

public abstract class AbstractSolvabilityOPPLOWLAxiomSearchTree
extends SearchTree<SolvabilitySearchNode> {
    private final ConstraintSystem constraintSystem;
    private final RuntimeExceptionHandler runtimeExceptionHandler;
    private final VariableTypeVisitorEx<Set<? extends OWLObject>> assignableValuesVisitor = new VariableTypeVisitorEx<Set<? extends OWLObject>>(){

        @Override
        public Set<? extends OWLObject> visitCLASSVariableType(CLASSVariableType classVariableType) {
            return AbstractSolvabilityOPPLOWLAxiomSearchTree.this.allClasses;
        }

        @Override
        public Set<? extends OWLObject> visitOBJECTPROPERTYVariableType(OBJECTPROPERTYVariableType objectpropertyVariableType) {
            return AbstractSolvabilityOPPLOWLAxiomSearchTree.this.allObjectProperties;
        }

        @Override
        public Set<? extends OWLObject> visitDATAPROPERTYVariableType(DATAPROPERTYVariableType datapropertyVariableType) {
            return AbstractSolvabilityOPPLOWLAxiomSearchTree.this.allDataProperties;
        }

        @Override
        public Set<? extends OWLObject> visitINDIVIDUALVariableType(INDIVIDUALVariableType individualVariableType) {
            return AbstractSolvabilityOPPLOWLAxiomSearchTree.this.allIndividuals;
        }

        @Override
        public Set<? extends OWLObject> visitCONSTANTVariableType(CONSTANTVariableType constantVariableType) {
            return AbstractSolvabilityOPPLOWLAxiomSearchTree.this.allConstants;
        }

        @Override
        public Set<? extends OWLObject> visitANNOTATIONPROPERTYVariableType(ANNOTATIONPROPERTYVariableType annotationpropertyVariableType) {
            return AbstractSolvabilityOPPLOWLAxiomSearchTree.this.allAnnotationProperties;
        }
    };
    protected final Set<OWLClass> allClasses = new HashSet<OWLClass>();
    protected final Set<OWLLiteral> allConstants = new HashSet<OWLLiteral>();
    protected final Set<OWLDataProperty> allDataProperties = new HashSet<OWLDataProperty>();
    protected final Set<OWLIndividual> allIndividuals = new HashSet<OWLIndividual>();
    protected final Set<OWLObjectProperty> allObjectProperties = new HashSet<OWLObjectProperty>();
    protected final Set<OWLAnnotationProperty> allAnnotationProperties = new HashSet<OWLAnnotationProperty>();

    public AbstractSolvabilityOPPLOWLAxiomSearchTree(ConstraintSystem constraintSystem, RuntimeExceptionHandler runtimeExceptionHandler) {
        this.constraintSystem = ArgCheck.checkNotNull(constraintSystem, "constraintSystem");
        this.runtimeExceptionHandler = ArgCheck.checkNotNull(runtimeExceptionHandler, "runtimeExceptionHandler");
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    @Override
    protected boolean goalReached(SolvabilitySearchNode node) {
        return node.accept(new SolvabilitySearchNodeVisitorEx<Boolean>(){

            @Override
            public Boolean visitSolvedSearchNode(SolvedSearchNode solvedSearchNode) {
                return true;
            }

            @Override
            public Boolean visitNoSolutionSolvableSearchNode(NoSolutionSolvableSearchNode noSolutionSolvableSearchNode) {
                return false;
            }

            @Override
            public Boolean visitSolvableSearchNode(SolvableSearchNode solvableSearchNode) {
                return false;
            }

            @Override
            public Boolean visitUnsolvableSearchNode(UnsolvableSearchNode unsolvableSearchNode) {
                return AbstractSolvabilityOPPLOWLAxiomSearchTree.this.goalReachedUnsolvabelNode(unsolvableSearchNode);
            }
        });
    }

    protected abstract boolean goalReachedUnsolvabelNode(UnsolvableSearchNode var1);

    @Override
    protected List<SolvabilitySearchNode> getChildren(SolvabilitySearchNode node) {
        return node.accept(new SolvabilitySearchNodeVisitorEx<List<SolvabilitySearchNode>>(){

            @Override
            public List<SolvabilitySearchNode> visitSolvableSearchNode(SolvableSearchNode solvableSearchNode) {
                ArrayList<SolvabilitySearchNode> toReturn = new ArrayList<SolvabilitySearchNode>(solvableSearchNode.getValues().size());
                Variable<?> variable = solvableSearchNode.getVariable();
                final BindingNode binding = solvableSearchNode.getBinding();
                for (final OWLObject value : solvableSearchNode.getValues()) {
                    boolean accepatble = variable.accept(new VariableVisitorEx<Boolean>(){

                        @Override
                        public <O extends OWLObject> Boolean visit(InputVariable<O> v) {
                            try {
                                return v.getVariableScope() == null || v.getVariableScope().check(value);
                            }
                            catch (OWLRuntimeException e) {
                                AbstractSolvabilityOPPLOWLAxiomSearchTree.this.getRuntimeExceptionHandler().handleOWLRuntimeException(e);
                                return false;
                            }
                        }

                        @Override
                        public <O extends OWLObject> Boolean visit(GeneratedVariable<O> v) {
                            return false;
                        }

                        @Override
                        public <O extends OWLObject> Boolean visit(RegexpGeneratedVariable<O> regExpGenerated) {
                            ManchesterSyntaxRenderer renderer = AbstractSolvabilityOPPLOWLAxiomSearchTree.this.getConstraintSystem().getOPPLFactory().getManchesterSyntaxRenderer(AbstractSolvabilityOPPLOWLAxiomSearchTree.this.getConstraintSystem());
                            value.accept((OWLObjectVisitor)renderer);
                            Matcher matcher = regExpGenerated.getPatternGeneratingOPPLFunction().compute(new SimpleValueComputationParameters(AbstractSolvabilityOPPLOWLAxiomSearchTree.this.getConstraintSystem(), binding, AbstractSolvabilityOPPLOWLAxiomSearchTree.this.getRuntimeExceptionHandler())).matcher(renderer.toString());
                            boolean matches = matcher.matches();
                            return matches;
                        }
                    });
                    if (!accepatble) continue;
                    Assignment assignment = new Assignment(variable, value);
                    BindingNode childBinding = new BindingNode(binding);
                    childBinding.addAssignment(assignment);
                    SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(AbstractSolvabilityOPPLOWLAxiomSearchTree.this.getConstraintSystem(), childBinding, AbstractSolvabilityOPPLOWLAxiomSearchTree.this.getRuntimeExceptionHandler());
                    PartialOWLObjectInstantiator instantiator = new PartialOWLObjectInstantiator(parameters);
                    OWLAxiom instantiatedAxiom = (OWLAxiom)solvableSearchNode.getAxiom().accept((OWLObjectVisitorEx)instantiator);
                    SolvedSearchNode child = new SolvedSearchNode(instantiatedAxiom, childBinding);
                    toReturn.add(child);
                }
                return toReturn;
            }

            @Override
            public List<SolvabilitySearchNode> visitSolvedSearchNode(SolvedSearchNode solvedSearchNode) {
                return Collections.emptyList();
            }

            @Override
            public List<SolvabilitySearchNode> visitUnsolvableSearchNode(UnsolvableSearchNode unsolvableSearchNode) {
                return AbstractSolvabilityOPPLOWLAxiomSearchTree.this.getUnsolvableNodeChildren(unsolvableSearchNode);
            }

            @Override
            public List<SolvabilitySearchNode> visitNoSolutionSolvableSearchNode(NoSolutionSolvableSearchNode noSolutionSolvableSearchNode) {
                return Collections.emptyList();
            }
        });
    }

    protected List<SolvabilitySearchNode> getUnsolvableNodeChildren(UnsolvableSearchNode node) {
        ArrayList<SolvabilitySearchNode> toReturn = new ArrayList<SolvabilitySearchNode>();
        VariableExtractor variableExtractor = new VariableExtractor(this.getConstraintSystem(), false);
        Set<Variable<?>> variables = variableExtractor.extractVariables((OWLObject)node.getAxiom());
        BindingNode binding = node.getBinding();
        SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(this.getConstraintSystem(), node.getBinding(), this.getRuntimeExceptionHandler());
        for (Variable<?> variable : variables) {
            HashSet<? extends OWLObject> values = new HashSet<OWLObject>();
            values.addAll(this.getAssignableValues(variable, parameters));
            for (OWLObject oWLObject : values) {
                Assignment assignment = new Assignment(variable, oWLObject);
                BindingNode childBinding = new BindingNode(binding);
                childBinding.addAssignment(assignment);
                SimpleValueComputationParameters newParameters = new SimpleValueComputationParameters(this.getConstraintSystem(), childBinding, this.getRuntimeExceptionHandler());
                PartialOWLObjectInstantiator instantiator = new PartialOWLObjectInstantiator(newParameters);
                OWLAxiom instantiatedAxiom = (OWLAxiom)node.getAxiom().accept((OWLObjectVisitorEx)instantiator);
                SolvabilitySearchNode child = SolvabilitySearchNode.buildSolvabilitySearchNode(instantiatedAxiom, this.getAxiomSolvability(), childBinding);
                toReturn.add(child);
            }
        }
        return toReturn;
    }

    private Collection<? extends OWLObject> getAssignableValues(Variable<?> variable, ValueComputationParameters parameters) {
        HashSet toReturn = new HashSet();
        toReturn.addAll(variable.accept(new AssignableValueExtractor(this.assignableValuesVisitor, parameters)));
        Iterator iterator = toReturn.iterator();
        while (iterator.hasNext()) {
            final OWLObject owlObject = (OWLObject)iterator.next();
            try {
                boolean inScope = variable.accept(new AbstractVariableVisitorExAdapter<Boolean>(Boolean.valueOf(true)){

                    @Override
                    public <P extends OWLObject> Boolean visit(InputVariable<P> v) {
                        VariableScope<?> variableScope = v.getVariableScope();
                        return variableScope == null || variableScope.check(owlObject);
                    }
                });
                if (inScope) continue;
                iterator.remove();
            }
            catch (OWLRuntimeException e) {
                this.getRuntimeExceptionHandler().handleOWLRuntimeException(e);
            }
        }
        return toReturn;
    }

    private void initAssignableValues() {
        this.allClasses.addAll(this.getAllClasses());
        Logging.getQueryLogger().fine("Possible class values ", (Object)this.allClasses.size());
        this.allDataProperties.addAll(this.getAllDataProperties());
        Logging.getQueryLogger().fine("Possible data property values ", (Object)this.allDataProperties.size());
        this.allObjectProperties.addAll(this.getObjectProperties());
        Logging.getQueryLogger().fine("Possible object property values ", (Object)this.allObjectProperties.size());
        this.allIndividuals.addAll(this.getAllIndividuals());
        Logging.getQueryLogger().fine("Possible individual  values ", (Object)this.allIndividuals.size());
        this.allConstants.addAll(this.getAllConstants());
        Logging.getQueryLogger().fine("Possible constant  values ", (Object)this.allConstants.size());
        this.allAnnotationProperties.addAll(this.getAllAnnotationProperties());
        Logging.getQueryLogger().fine("Possible annotation properties values ", (Object)this.allConstants.size());
    }

    private Collection<OWLClass> getAllClasses() {
        HashSet<OWLClass> toReturn = new HashSet<OWLClass>();
        for (OWLOntology owlOntology : this.getConstraintSystem().getOntologyManager().getOntologies()) {
            toReturn.addAll(owlOntology.getClassesInSignature());
        }
        return toReturn;
    }

    private Collection<OWLLiteral> getAllConstants() {
        HashSet<OWLLiteral> toReturn = new HashSet<OWLLiteral>();
        ConstantExtractor constantExtractor = new ConstantExtractor(toReturn);
        ConstantCollector visitor = new ConstantCollector(toReturn, (OWLClassExpressionVisitor)constantExtractor);
        for (OWLOntology owlOntology : this.getConstraintSystem().getOntologyManager().getOntologies()) {
            for (OWLAxiom axiomToVisit : owlOntology.getAxioms()) {
                axiomToVisit.accept((OWLAxiomVisitor)visitor);
            }
        }
        return toReturn;
    }

    private Collection<OWLDataProperty> getAllDataProperties() {
        HashSet<OWLDataProperty> toReturn = new HashSet<OWLDataProperty>();
        for (OWLOntology owlOntology : this.getConstraintSystem().getOntologyManager().getOntologies()) {
            toReturn.addAll(owlOntology.getDataPropertiesInSignature());
        }
        return toReturn;
    }

    private Collection<OWLIndividual> getAllIndividuals() {
        HashSet<OWLIndividual> toReturn = new HashSet<OWLIndividual>();
        for (OWLOntology owlOntology : this.getConstraintSystem().getOntologyManager().getOntologies()) {
            toReturn.addAll(owlOntology.getIndividualsInSignature());
        }
        return toReturn;
    }

    private Collection<OWLObjectProperty> getObjectProperties() {
        HashSet<OWLObjectProperty> toReturn = new HashSet<OWLObjectProperty>();
        for (OWLOntology owlOntology : this.getConstraintSystem().getOntologyManager().getOntologies()) {
            toReturn.addAll(owlOntology.getObjectPropertiesInSignature());
        }
        return toReturn;
    }

    @Override
    public boolean exhaustiveSearchTree(SolvabilitySearchNode start, List<List<SolvabilitySearchNode>> solutions) {
        this.initAssignableValues();
        boolean found = super.exhaustiveSearchTree(start, solutions);
        HashSet<BindingNode> newLeaves = new HashSet<BindingNode>();
        for (List path : solutions) {
            SolvabilitySearchNode leafSerachNode = (SolvabilitySearchNode)path.get(path.size() - 1);
            BindingNode newLeaf = leafSerachNode.getBinding();
            newLeaves.add(newLeaf);
        }
        return found;
    }

    protected abstract AxiomSolvability getAxiomSolvability();

    public SolvabilitySearchNode buildSolvabilitySearchNode(OWLAxiom axiom, BindingNode bindingNode) {
        return SolvabilitySearchNode.buildSolvabilitySearchNode(axiom, this.getAxiomSolvability(), bindingNode);
    }

    public RuntimeExceptionHandler getRuntimeExceptionHandler() {
        return this.runtimeExceptionHandler;
    }

    private Set<OWLAnnotationProperty> getAllAnnotationProperties() {
        HashSet<OWLAnnotationProperty> toReturn = new HashSet<OWLAnnotationProperty>();
        for (OWLOntology ontology : this.getConstraintSystem().getOntologyManager().getOntologies()) {
            toReturn.addAll(ontology.getAnnotationPropertiesInSignature());
        }
        return toReturn;
    }

    private final class ConstantCollector
    extends OWLAxiomVisitorAdapter {
        private final Set<OWLLiteral> toReturn;
        private final OWLClassExpressionVisitor constantExtractor;

        ConstantCollector(Set<OWLLiteral> toReturn, OWLClassExpressionVisitor constantExtractor) {
            this.toReturn = toReturn;
            this.constantExtractor = constantExtractor;
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            axiom.getClassExpression().accept(this.constantExtractor);
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            this.toReturn.add((OWLLiteral)axiom.getObject());
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            for (OWLClassExpression description : axiom.getClassExpressions()) {
                description.accept(this.constantExtractor);
            }
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            for (OWLClassExpression description : axiom.getClassExpressions()) {
                description.accept(this.constantExtractor);
            }
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            this.toReturn.add((OWLLiteral)axiom.getObject());
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            axiom.getSubClass().accept(this.constantExtractor);
            axiom.getSuperClass().accept(this.constantExtractor);
        }
    }
}

