/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.querymatching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.Variable;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.querymatching.AbstractAxiomQuery;
import org.coode.oppl.search.OPPLInferredOWLAxiomSearchTree;
import org.coode.oppl.search.OPPLOWLAxiomSearchNode;
import org.coode.oppl.search.solvability.InferredSolvabilitySearchTree;
import org.coode.oppl.search.solvability.SolvabilitySearchNode;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.utils.PositionBasedVariableComparator;
import org.coode.oppl.utils.VariableExtractor;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;

public class InferredSolvabilityBasedTreeSearchAxiomQuery
extends AbstractAxiomQuery {
    private final ConstraintSystem constraintSystem;
    private final Map<BindingNode, Set<OWLAxiom>> instantiations = new HashMap<BindingNode, Set<OWLAxiom>>();

    public InferredSolvabilityBasedTreeSearchAxiomQuery(ConstraintSystem constraintSystem, RuntimeExceptionHandler runtimeExceptionHandler) {
        super(runtimeExceptionHandler);
        this.constraintSystem = ArgCheck.checkNotNull(constraintSystem, "constraintSystem");
    }

    @Override
    protected Set<BindingNode> match(OWLAxiom axiom) {
        this.clearInstantions();
        ArrayList<List<? extends OPPLOWLAxiomSearchNode>> solutions = new ArrayList<List<? extends OPPLOWLAxiomSearchNode>>();
        VariableExtractor variableExtractor = new VariableExtractor(this.getConstraintSystem(), false);
        Set<Variable<?>> extractedVariables = variableExtractor.extractVariables((OWLObject)axiom);
        TreeSet sortedVariables = new TreeSet(new PositionBasedVariableComparator((OWLObject)axiom, this.getConstraintSystem().getOntologyManager().getOWLDataFactory()));
        sortedVariables.addAll(extractedVariables);
        OPPLOWLAxiomSearchNode start = new OPPLOWLAxiomSearchNode(axiom, new BindingNode(sortedVariables));
        solutions.addAll(this.doMatch(start));
        return this.extractLeaves(solutions);
    }

    private List<List<? extends OPPLOWLAxiomSearchNode>> doMatch(OPPLOWLAxiomSearchNode start) {
        ArrayList<List<? extends OPPLOWLAxiomSearchNode>> solutions = new ArrayList<List<? extends OPPLOWLAxiomSearchNode>>();
        OWLAxiom axiom = start.getAxiom();
        if (axiom.getAxiomType() == AxiomType.SUBCLASS_OF || axiom.getAxiomType() == AxiomType.OBJECT_PROPERTY_ASSERTION) {
            solutions.addAll(this.solvabilityBasedMatching(start.getAxiom(), start.getBinding()));
        } else {
            solutions.addAll(this.nonSolvabilityBasedMatch(start));
        }
        return solutions;
    }

    private List<List<OPPLOWLAxiomSearchNode>> nonSolvabilityBasedMatch(OPPLOWLAxiomSearchNode start) {
        ArrayList<List<OPPLOWLAxiomSearchNode>> solutions = new ArrayList<List<OPPLOWLAxiomSearchNode>>();
        OPPLInferredOWLAxiomSearchTree searchTree = new OPPLInferredOWLAxiomSearchTree(this.getConstraintSystem(), this.getRuntimeExceptionHandler());
        searchTree.exhaustiveSearchTree(start, (List<List<OPPLOWLAxiomSearchNode>>)solutions);
        return solutions;
    }

    private List<List<SolvabilitySearchNode>> solvabilityBasedMatching(OWLAxiom axiom, BindingNode bindingNode) {
        InferredSolvabilitySearchTree searchTree = new InferredSolvabilitySearchTree(this.getConstraintSystem(), this.getRuntimeExceptionHandler());
        ArrayList<List<SolvabilitySearchNode>> solutions = new ArrayList<List<SolvabilitySearchNode>>();
        SolvabilitySearchNode start = searchTree.buildSolvabilitySearchNode(axiom, bindingNode);
        searchTree.exhaustiveSearchTree(start, (List<List<SolvabilitySearchNode>>)solutions);
        return solutions;
    }

    private Set<BindingNode> extractLeaves(List<List<? extends OPPLOWLAxiomSearchNode>> solutions) {
        HashSet<BindingNode> toReturn = new HashSet<BindingNode>();
        for (List<? extends OPPLOWLAxiomSearchNode> path : solutions) {
            OPPLOWLAxiomSearchNode searchLeaf = path.get(path.size() - 1);
            BindingNode leaf = searchLeaf.getBinding();
            toReturn.add(leaf);
        }
        return toReturn;
    }

    private void clearInstantions() {
        this.instantiations.clear();
    }

    public Map<BindingNode, Set<OWLAxiom>> getInstantiations() {
        return new HashMap<BindingNode, Set<OWLAxiom>>(this.instantiations);
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }
}

